/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTaskForPhysicalDataSets;
import ch.systemsx.cisd.etlserver.postregistration.ArchivingExecutor;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManagerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiver;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetStatusUpdater;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SecondCopyPostRegistrationTask
extends AbstractPostRegistrationTaskForPhysicalDataSets {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SecondCopyPostRegistrationTask.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, SecondCopyPostRegistrationTask.class);
    private final IHierarchicalContentProvider hierarchicalContentProvider;
    private final IDataSetDirectoryProvider dataSetDirectoryProvider;
    private final IArchiverPlugin archiver;
    private final Template notificationTemplate;

    public SecondCopyPostRegistrationTask(Properties properties, IEncapsulatedOpenBISService service) {
        this(properties, service, ServiceProvider.getDataStoreService(), ServiceProvider.getHierarchicalContentProvider());
    }

    SecondCopyPostRegistrationTask(Properties properties, IEncapsulatedOpenBISService service, IDataStoreServiceInternal dataStoreService, IHierarchicalContentProvider hierarchicalContentProvider) {
        super(properties, service);
        this.hierarchicalContentProvider = hierarchicalContentProvider;
        RsyncArchiver.DataSetFileOperationsManagerFactory factory = new RsyncArchiver.DataSetFileOperationsManagerFactory(properties);
        IDataSetFileOperationsManager fileOperationManager = factory.create();
        if (fileOperationManager.isHosted()) {
            throw new ConfigurationFailureException("Destination should be on a local or mounted drive.");
        }
        this.dataSetDirectoryProvider = dataStoreService.getDataSetDirectoryProvider();
        File storeRoot = this.dataSetDirectoryProvider.getStoreRoot();
        properties.setProperty("synchronize-archive", "false");
        this.notificationTemplate = new Template("Creating a second copy of dataset '${dataSet}' has failed.\n${errors}");
        this.archiver = new Archiver(properties, storeRoot, service, factory, dataStoreService.getDataSetDirectoryProvider().getShareIdManager());
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode) {
        return new ArchivingExecutor(dataSetCode, false, this.notificationTemplate, this.service, this.archiver, this.dataSetDirectoryProvider, this.hierarchicalContentProvider, operationLog, notificationLog);
    }

    private static final class Archiver
    extends RsyncArchiver {
        private static final long serialVersionUID = 1L;

        Archiver(Properties properties, File storeRoot, IEncapsulatedOpenBISService service, IDataSetFileOperationsManagerFactory fileOperationsManagerFactory, IShareIdManager shareIdManager) {
            super(properties, storeRoot, fileOperationsManagerFactory, RsyncArchiver.DeleteAction.DELETE, RsyncArchiver.ChecksumVerificationCondition.IF_AVAILABLE);
            this.setService(service);
            this.setStatusUpdater(new IDataSetStatusUpdater(){

                @Override
                public void update(List<String> dataSetCodes, DataSetArchivingStatus status, boolean presentInArchive) {
                }
            });
            this.setShareIdManager(shareIdManager);
        }
    }
}

