/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.impl;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.ITransactionalCommand;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.log4j.Logger;

public class RollbackStack
implements IRollbackStack {
    private final File commandsFile;
    private final File commandOffsetsFile;
    private final File indexFile;
    private final File lockedMarkerFile;
    private final Logger operationLog;
    private long currentOffset;
    private DataOutputStream commandsOutputStream;
    private DataOutputStream indicesOutputStream;

    public RollbackStack(File commandsFile) {
        this(commandsFile, null);
    }

    public RollbackStack(File commandsFile, Logger operationLog) {
        this.commandsFile = commandsFile;
        this.operationLog = operationLog == null ? LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RollbackStack.class) : operationLog;
        this.commandOffsetsFile = new File(commandsFile.getParentFile(), commandsFile.getName() + ".offsets");
        this.indexFile = new File(commandsFile.getParentFile(), commandsFile.getName() + ".index");
        this.lockedMarkerFile = new File(commandsFile.getParentFile(), commandsFile.getName() + ".LOCKED");
        this.operationLog.info((Object)("Rollback stack: " + commandsFile));
    }

    public int getSize() {
        return (int)(this.commandOffsetsFile.length() / 8L);
    }

    @Override
    public void pushAndExecuteCommand(ITransactionalCommand cmd) {
        try {
            byte[] serializedCommand = SerializationUtils.serialize((Serializable)cmd);
            if (this.indicesOutputStream == null) {
                this.indicesOutputStream = new DataOutputStream(new FileOutputStream(this.commandOffsetsFile, true));
                this.currentOffset = 0L;
            }
            this.currentOffset += (long)serializedCommand.length;
            this.indicesOutputStream.writeLong(this.currentOffset);
            this.indicesOutputStream.flush();
            if (this.commandsOutputStream == null) {
                this.commandsOutputStream = new DataOutputStream(new FileOutputStream(this.commandsFile, true));
            }
            this.commandsOutputStream.write(serializedCommand);
            cmd.execute();
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    public void rollbackAll() {
        this.rollbackAll(new IRollbackStackDelegate(){

            @Override
            public void willContinueRollbackAll(RollbackStack stack) {
            }
        });
    }

    public void rollbackAll(IRollbackStackDelegate delegate) {
        block14: {
            if (this.isLockedState()) {
                throw new IllegalStateException("Rollback stack is in the locked state. Triggering rollback forbidden.");
            }
            RandomAccessFile rafile = null;
            try {
                long[] offsets = this.loadOffsets();
                int initialIndex = this.loadIndex(offsets);
                if (initialIndex < 0) break block14;
                this.operationLog.info((Object)("Rolling back " + (initialIndex + 1) + " of " + offsets.length + " commands"));
                rafile = new RandomAccessFile(this.commandsFile, "r");
                int numberOfRolledBackCommands = 0;
                for (int index = initialIndex; index >= 0; --index) {
                    delegate.willContinueRollbackAll(this);
                    long offset2 = offsets[index];
                    long offset1 = index == 0 ? 0L : offsets[index - 1];
                    rafile.seek(offset1);
                    byte[] bytes = new byte[(int)(offset2 - offset1)];
                    rafile.read(bytes);
                    ITransactionalCommand cmd = (ITransactionalCommand)SerializationUtils.deserialize((byte[])bytes);
                    try {
                        cmd.rollback();
                    }
                    catch (Throwable t) {
                        this.operationLog.error((Object)("Encountered error rolling back command " + cmd.toString()), t);
                    }
                    this.saveIndex(index - 1);
                    if (++numberOfRolledBackCommands % 100 != 0) continue;
                    this.operationLog.info((Object)(numberOfRolledBackCommands + " commands rolled back"));
                }
            }
            catch (Exception e) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
            }
            finally {
                if (rafile != null) {
                    try {
                        rafile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] loadOffsets() throws Exception {
        if (!this.commandOffsetsFile.exists()) {
            return new long[0];
        }
        FilterInputStream stream = null;
        try {
            long[] offsets = new long[this.getSize()];
            stream = new DataInputStream(new FileInputStream(this.commandOffsetsFile));
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = ((DataInputStream)stream).readLong();
            }
            long[] lArray = offsets;
            return lArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private int loadIndex(long[] offsets) {
        if (!this.indexFile.exists()) {
            return offsets.length - 1;
        }
        return Integer.parseInt(FileUtilities.loadExactToString((File)this.indexFile));
    }

    private void saveIndex(int index) {
        FileUtilities.writeToFile((File)this.indexFile, (String)Integer.toString(index));
    }

    public void discard() {
        if (this.isLockedState()) {
            throw new IllegalStateException("Discarding of locked rollback stack is illegal. Set locked to false first.");
        }
        this.commandOffsetsFile.delete();
        this.commandsFile.delete();
        this.indexFile.delete();
    }

    public String toString() {
        return "RollbackStack " + this.commandsFile + " with " + this.getSize() + " commands to roll back";
    }

    public File getCommandsFile() {
        return this.commandsFile;
    }

    @Override
    public void setLockedState(boolean lockedState) {
        if (!lockedState && this.isLockedState()) {
            this.deleteLockedMarkerFile();
        } else if (lockedState && !this.isLockedState()) {
            this.createLockedMarkerFile();
        }
    }

    @Override
    public boolean isLockedState() {
        return this.lockedMarkerFile.exists();
    }

    private void deleteLockedMarkerFile() {
        this.lockedMarkerFile.delete();
    }

    private void createLockedMarkerFile() {
        try {
            this.lockedMarkerFile.createNewFile();
        }
        catch (IOException ex) {
            this.operationLog.fatal((Object)("Failed to create rollback stack lock marker file " + this.lockedMarkerFile.getAbsolutePath()));
        }
    }

    public static interface IRollbackStackDelegate {
        public void willContinueRollbackAll(RollbackStack var1);
    }
}

