/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.common.action.IMapper;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.AuthorizationHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.authorization.IAuthorizationService;
import java.util.List;

public class AuthorizationService
implements IAuthorizationService {
    private IEncapsulatedOpenBISService openBisService;

    public AuthorizationService(IEncapsulatedOpenBISService openBisService) {
        this.openBisService = openBisService;
    }

    @Override
    public boolean doesUserHaveRole(String user, String role, String spaceOrNull) {
        return this.openBisService.doesUserHaveRole(user, role, spaceOrNull);
    }

    @Override
    public List<IDataSetImmutable> filterToVisibleDatasets(String user, List<IDataSetImmutable> datasets) {
        IMapper<IDataSetImmutable, String> codeMapper = new IMapper<IDataSetImmutable, String>(){

            public String map(IDataSetImmutable item) {
                return item.getDataSetCode();
            }
        };
        return AuthorizationHelper.filterToVisible(this.openBisService, user, datasets, codeMapper, AuthorizationHelper.EntityKind.DATA_SET);
    }

    @Override
    public List<IExperimentImmutable> filterToVisibleExperiments(String user, List<IExperimentImmutable> experiments) {
        IMapper<IExperimentImmutable, String> idMapper = new IMapper<IExperimentImmutable, String>(){

            public String map(IExperimentImmutable item) {
                return item.getExperimentIdentifier();
            }
        };
        return AuthorizationHelper.filterToVisible(this.openBisService, user, experiments, idMapper, AuthorizationHelper.EntityKind.EXPERIMENT);
    }

    @Override
    public List<ISampleImmutable> filterToVisibleSamples(String user, List<ISampleImmutable> samples) {
        IMapper<ISampleImmutable, String> idMapper = new IMapper<ISampleImmutable, String>(){

            public String map(ISampleImmutable item) {
                return item.getSampleIdentifier();
            }
        };
        return AuthorizationHelper.filterToVisible(this.openBisService, user, samples, idMapper, AuthorizationHelper.EntityKind.SAMPLE);
    }
}

