/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IMaterialImmutable;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.MaterialCodeAndTypeCodeId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;

public class MaterialImmutable
implements IMaterialImmutable {
    private final Material material;
    private final boolean existingMaterial;

    public MaterialImmutable(Material material) {
        this(material, true);
    }

    public MaterialImmutable(Material material, boolean existingMaterial) {
        this.material = material;
        this.existingMaterial = existingMaterial;
    }

    @Override
    public String getMaterialIdentifier() {
        return this.material.getIdentifier();
    }

    @Override
    public String getCode() {
        return this.material.getCode();
    }

    @Override
    public String getMaterialType() {
        if (this.material.getMaterialType() != null) {
            return this.material.getMaterialType().getCode();
        }
        return null;
    }

    @Override
    public IObjectId getEntityId() {
        return new MaterialCodeAndTypeCodeId(this.getCode(), this.getMaterialType());
    }

    @Override
    public boolean isExistingMaterial() {
        return this.existingMaterial;
    }

    public Material getMaterial() {
        return this.material;
    }

    protected void checkExists() {
        if (!this.isExistingMaterial()) {
            throw new UserFailureException("Material does not exist.");
        }
    }

    @Override
    public String getPropertyValue(String propertyCode) {
        return EntityHelper.tryFindPropertyValue((IEntityPropertiesHolder)this.material, (String)propertyCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaterialImmutable)) {
            return false;
        }
        MaterialImmutable other = (MaterialImmutable)obj;
        return !(this.getMaterialIdentifier() == null ? other.getMaterialIdentifier() != null : !this.getMaterialIdentifier().equals(other.getMaterialIdentifier()));
    }
}

