/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.api.v2.DataSetRegistrationServiceV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonDataSetRegistrationServiceV2;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractProgrammableTopLevelDataSetHandler;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.Properties;

public class JavaTopLevelDataSetHandlerV2<T extends DataSetInformation>
extends AbstractProgrammableTopLevelDataSetHandler<T> {
    public static final String PROGRAM_CLASS_KEY = "program-class";
    private Class<? extends IJavaDataSetRegistrationDropboxV2> programClass;
    private String className;
    private String dropboxName;

    public JavaTopLevelDataSetHandlerV2(TopLevelDataSetRegistratorGlobalState globalState) {
        super(globalState);
        this.className = PropertyUtils.getMandatoryProperty((Properties)globalState.getThreadParameters().getThreadProperties(), (String)PROGRAM_CLASS_KEY);
        this.dropboxName = globalState.getThreadParameters().getThreadName();
        PluginContainer container = PluginContainer.tryGetInstance((String)this.dropboxName);
        if (container != null) {
            this.programClass = container.tryGetPluginClassByClassname(this.className);
        }
        if (this.programClass == null) {
            try {
                this.programClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException ex) {
                throw ConfigurationFailureException.fromTemplate((String)"Class '%s' does not exist!", (Object[])new Object[]{this.className});
            }
        }
        DssRegistrationHealthMonitor.getInstance(globalState.getOpenBisService(), globalState.getRecoveryStateDir());
    }

    @Override
    public boolean shouldNotAddToFaultyPathsOrNull(File file) {
        return this.hasRecoveryMarkerFile(file);
    }

    @Override
    protected void handleDataSet(DataSetFile dataSetFile, DataSetRegistrationService<T> service) throws Throwable {
        this.waitUntilApplicationIsReady(service, dataSetFile);
        IJavaDataSetRegistrationDropboxV2 v2Programm = this.getV2DropboxProgram(service);
        if (v2Programm.isRetryFunctionDefined()) {
            this.executeProcessFunctionWithRetries(v2Programm, (JythonDataSetRegistrationServiceV2)service, dataSetFile);
        } else {
            service.getDssRegistrationLog().info(operationLog, "Start processing");
            v2Programm.process(this.wrapTransaction(service.transaction()));
        }
    }

    @Override
    protected AbstractProgrammableTopLevelDataSetHandler.RecoveryHookAdaptor getRecoveryHookAdaptor(File incoming) {
        return new AbstractProgrammableTopLevelDataSetHandler.RecoveryHookAdaptor(incoming){
            IJavaDataSetRegistrationDropboxV2 v2ProgramInternal;

            @Override
            protected IJavaDataSetRegistrationDropboxV2 getV2DropboxProgramInternal() {
                if (this.v2ProgramInternal == null) {
                    this.v2ProgramInternal = JavaTopLevelDataSetHandlerV2.this.getV2DropboxProgram(null);
                }
                return this.v2ProgramInternal;
            }
        };
    }

    @Override
    protected DataSetRegistrationService<T> createDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return new DataSetRegistrationServiceV2(this, incomingDataSetFile, userProvidedDataSetInformationOrNull, cleanAfterwardsAction, delegate);
    }

    @Override
    protected boolean hasRecoveryMarkerFile(File incoming) {
        return this.getGlobalState().getStorageRecoveryManager().getProcessingMarkerFile(incoming).exists();
    }

    @Override
    protected IJavaDataSetRegistrationDropboxV2 getV2DropboxProgram(DataSetRegistrationService<T> service) {
        try {
            Class clazz;
            PluginContainer container = PluginContainer.tryGetInstance((String)this.dropboxName);
            if (container != null && (clazz = container.tryGetPluginClassByClassname(this.className)) != null) {
                return (IJavaDataSetRegistrationDropboxV2)clazz.newInstance();
            }
            return this.programClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

