/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.jython.IJythonFunction;
import ch.systemsx.cisd.common.jython.IJythonInterpreter;
import ch.systemsx.cisd.common.jython.IJythonObject;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonTopLevelDataSetHandlerV2;
import org.apache.log4j.Logger;

public class JythonAsJavaDataSetRegistrationDropboxV2Wrapper
implements IJavaDataSetRegistrationDropboxV2 {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, JythonAsJavaDataSetRegistrationDropboxV2Wrapper.class);
    private IJythonInterpreter interpreter;
    private Boolean retryDefined;

    public JythonAsJavaDataSetRegistrationDropboxV2Wrapper(IJythonInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void process(IDataSetRegistrationTransactionV2 transaction) {
        try {
            IJythonFunction function = this.interpreter.tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.PROCESS_FUNCTION.name);
            if (function == null) {
                throw new IllegalStateException("Undefined process() function");
            }
            function.invoke(new Object[]{transaction});
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    @Override
    public void postStorage(DataSetRegistrationContext context) {
        IJythonFunction function = this.getInterpreter().tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.POST_STORAGE_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("postStorage is not implemented.");
        }
        function.invoke(new Object[]{context});
    }

    @Override
    public void preMetadataRegistration(DataSetRegistrationContext context) {
        IJythonFunction function = this.getInterpreter().tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.PRE_REGISTRATION_FUNCTION_NAME.name);
        if (null == function) {
            throw new NotImplementedException("preMetadataRegistration is not implemented.");
        }
        function.invoke(new Object[]{context});
    }

    @Override
    public void postMetadataRegistration(DataSetRegistrationContext context) {
        IJythonFunction function = this.getInterpreter().tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.POST_REGISTRATION_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("postMetadataRegistration is not implemented.");
        }
        function.invoke(new Object[]{context});
    }

    @Override
    public void rollbackPreRegistration(DataSetRegistrationContext context, Throwable throwable) {
        IJythonFunction function = this.getInterpreter().tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.ROLLBACK_PRE_REGISTRATION_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("rollbackPreRegistration is not implemented.");
        }
        function.invoke(new Object[]{context, throwable});
    }

    @Override
    public boolean isRetryFunctionDefined() {
        if (this.retryDefined == null) {
            IJythonFunction function = this.getInterpreter().tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.SHOULD_RETRY_PROCESS_FUNCTION_NAME.name);
            this.retryDefined = function == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.retryDefined;
    }

    @Override
    public boolean shouldRetryProcessing(DataSetRegistrationContext context, Exception problem) {
        if (!this.isRetryFunctionDefined()) {
            throw new NotImplementedException("shouldRetryProcessing is not implemented.");
        }
        IJythonFunction retryFunction = this.getInterpreter().tryJythonFunction(JythonTopLevelDataSetHandlerV2.JythonHookFunction.SHOULD_RETRY_PROCESS_FUNCTION_NAME.name);
        IJythonObject retryFunctionResult = null;
        try {
            retryFunctionResult = retryFunction.invoke(new Object[]{context, problem});
        }
        catch (Exception ex) {
            operationLog.error((Object)"The retry function has failed. Rolling back.", (Throwable)ex);
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        if (retryFunctionResult == null) {
            operationLog.error((Object)"The should_retry_processing function did not return anything. Will not retry.");
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)problem);
        }
        if (!retryFunctionResult.isInteger()) {
            operationLog.error((Object)("The should_retry_processing function returned object of non-boolean type " + retryFunctionResult.getClass() + ". Will not retry."));
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)problem);
        }
        return retryFunctionResult.asInteger() != 0;
    }

    private IJythonInterpreter getInterpreter() {
        return this.interpreter;
    }
}

