/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.common.action.IMapper;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class AuthorizationHelper {
    public static <T> List<T> filterToVisible(IEncapsulatedOpenBISService openBisService, String user, List<T> entities, IMapper<T, String> codeMapper, EntityKind entityKind) {
        LinkedList<String> codes = new LinkedList<String>();
        for (T entity : entities) {
            codes.add((String)codeMapper.map(entity));
        }
        List<String> filteredCodes = entityKind.filterToVisible(openBisService, user, codes);
        HashSet<String> filteredSet = new HashSet<String>(filteredCodes);
        LinkedList<T> resultList = new LinkedList<T>();
        for (T entity : entities) {
            if (!filteredSet.contains(codeMapper.map(entity))) continue;
            resultList.add(entity);
        }
        return resultList;
    }

    public static enum EntityKind {
        EXPERIMENT{

            @Override
            List<String> filterToVisible(IEncapsulatedOpenBISService openBisService, String user, List<String> codes) {
                return openBisService.filterToVisibleExperiments(user, codes);
            }
        }
        ,
        SAMPLE{

            @Override
            List<String> filterToVisible(IEncapsulatedOpenBISService openBisService, String user, List<String> codes) {
                return openBisService.filterToVisibleSamples(user, codes);
            }
        }
        ,
        DATA_SET{

            @Override
            List<String> filterToVisible(IEncapsulatedOpenBISService openBisService, String user, List<String> codes) {
                return openBisService.filterToVisibleDataSets(user, codes);
            }
        };


        abstract List<String> filterToVisible(IEncapsulatedOpenBISService var1, String var2, List<String> var3);
    }
}

