/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.common.action.IMapper;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.AuthorizationGroupImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.AuthorizationHelper;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.RoleAssignmentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.UserImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IAuthorizationGroupImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IRoleAssignmentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IUserImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.authorization.IAuthorizationService;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationService
implements IAuthorizationService {
    private IEncapsulatedOpenBISService openBisService;

    public AuthorizationService(IEncapsulatedOpenBISService openBisService) {
        this.openBisService = openBisService;
    }

    @Override
    public boolean doesUserHaveRole(String user, String role, String spaceOrNull) {
        return this.openBisService.doesUserHaveRole(user, role, spaceOrNull);
    }

    @Override
    public List<IDataSetImmutable> filterToVisibleDatasets(String user, List<IDataSetImmutable> datasets) {
        IMapper<IDataSetImmutable, String> codeMapper = new IMapper<IDataSetImmutable, String>(){

            public String map(IDataSetImmutable item) {
                return item.getDataSetCode();
            }
        };
        return AuthorizationHelper.filterToVisible(this.openBisService, user, datasets, codeMapper, AuthorizationHelper.EntityKind.DATA_SET);
    }

    @Override
    public List<IExperimentImmutable> filterToVisibleExperiments(String user, List<IExperimentImmutable> experiments) {
        IMapper<IExperimentImmutable, String> idMapper = new IMapper<IExperimentImmutable, String>(){

            public String map(IExperimentImmutable item) {
                return item.getExperimentIdentifier();
            }
        };
        return AuthorizationHelper.filterToVisible(this.openBisService, user, experiments, idMapper, AuthorizationHelper.EntityKind.EXPERIMENT);
    }

    @Override
    public List<ISampleImmutable> filterToVisibleSamples(String user, List<ISampleImmutable> samples) {
        IMapper<ISampleImmutable, String> idMapper = new IMapper<ISampleImmutable, String>(){

            public String map(ISampleImmutable item) {
                return item.getSampleIdentifier();
            }
        };
        return AuthorizationHelper.filterToVisible(this.openBisService, user, samples, idMapper, AuthorizationHelper.EntityKind.SAMPLE);
    }

    @Override
    public List<IAuthorizationGroupImmutable> listAuthorizationGroups() {
        ArrayList<IAuthorizationGroupImmutable> authorizationGroups = new ArrayList<IAuthorizationGroupImmutable>();
        List<AuthorizationGroup> authorizationGroupDtos = this.openBisService.listAuthorizationGroups();
        for (AuthorizationGroup authorizationGroupDto : authorizationGroupDtos) {
            authorizationGroups.add(new AuthorizationGroupImmutable(authorizationGroupDto));
        }
        return authorizationGroups;
    }

    @Override
    public List<IAuthorizationGroupImmutable> listAuthorizationGroupsForUser(String userId) {
        ArrayList<IAuthorizationGroupImmutable> authorizationGroups = new ArrayList<IAuthorizationGroupImmutable>();
        List<AuthorizationGroup> authorizationGroupDtos = this.openBisService.listAuthorizationGroupsForUser(userId);
        for (AuthorizationGroup authorizationGroupDto : authorizationGroupDtos) {
            authorizationGroups.add(new AuthorizationGroupImmutable(authorizationGroupDto));
        }
        return authorizationGroups;
    }

    @Override
    public List<IUserImmutable> listUsersForAuthorizationGroup(IAuthorizationGroupImmutable authorizationGroup) {
        ArrayList<IUserImmutable> users = new ArrayList<IUserImmutable>();
        TechId authorizationGroupId = TechId.create((IIdHolder)((AuthorizationGroupImmutable)authorizationGroup));
        List<Person> persons = this.openBisService.listUsersForAuthorizationGroup(authorizationGroupId);
        for (Person person : persons) {
            users.add(new UserImmutable(person));
        }
        return users;
    }

    @Override
    public List<IRoleAssignmentImmutable> listRoleAssignments() {
        ArrayList<IRoleAssignmentImmutable> roleAssignments = new ArrayList<IRoleAssignmentImmutable>();
        List<RoleAssignment> roleAssignmentDtos = this.openBisService.listRoleAssignments();
        for (RoleAssignment roleAssignment : roleAssignmentDtos) {
            if (roleAssignment.getProject() != null) continue;
            roleAssignments.add(new RoleAssignmentImmutable(roleAssignment));
        }
        return roleAssignments;
    }
}

