/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.Experiment;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ExperimentUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.Material;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.Metaproject;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.MetaprojectImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.Project;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.Sample;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.Space;
import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IMetaprojectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.Translator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMetaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewLinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;

public class ConversionUtils {
    public static NewExperiment convertToNewExperiment(Experiment apiExperiment) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment experiment = apiExperiment.getExperiment();
        NewExperiment newExperiment = new NewExperiment();
        newExperiment.setIdentifier(experiment.getIdentifier());
        newExperiment.setPermID(experiment.getPermId());
        if (experiment.getExperimentType() != null) {
            newExperiment.setExperimentTypeCode(experiment.getExperimentType().getCode());
        }
        IEntityProperty[] properties = experiment.getProperties().toArray(new IEntityProperty[0]);
        newExperiment.setProperties(properties);
        newExperiment.setAttachments(apiExperiment.getNewAttachments());
        return newExperiment;
    }

    public static ExperimentUpdatesDTO convertToExperimentUpdateDTO(ExperimentUpdatable apiExperiment) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment experiment = apiExperiment.getExperiment();
        ExperimentUpdatesDTO updates = new ExperimentUpdatesDTO();
        updates.setVersion(experiment.getVersion());
        updates.setExperimentId(new TechId(experiment.getId()));
        updates.setAttachments(Collections.emptySet());
        updates.setProjectIdentifier(new ProjectIdentifierFactory(experiment.getProject().getIdentifier()).createIdentifier());
        updates.setProperties(experiment.getProperties());
        updates.setAttachments(apiExperiment.getNewAttachments());
        return updates;
    }

    public static NewSample convertToNewSample(Sample apiSample) {
        Set parentsSet;
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = apiSample.getSample();
        NewSample newSample = new NewSample();
        newSample.setIdentifier(sample.getIdentifier());
        newSample.setPermID(sample.getPermId());
        if (sample.getExperiment() != null) {
            newSample.setExperimentIdentifier(sample.getExperiment().getIdentifier());
        }
        if (sample.getContainer() != null) {
            newSample.setContainerIdentifier(sample.getContainer().getIdentifier());
        }
        if ((parentsSet = sample.getParents()) != null && parentsSet.size() > 0) {
            String[] parentIdentifiers = new String[parentsSet.size()];
            int i = 0;
            for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample parent : parentsSet) {
                parentIdentifiers[i++] = parent.getIdentifier();
            }
            newSample.setParentsOrNull(parentIdentifiers);
        }
        newSample.setSampleType(sample.getSampleType());
        IEntityProperty[] properties = sample.getProperties().toArray(new IEntityProperty[0]);
        newSample.setProperties(properties);
        newSample.setAttachments(apiSample.getNewAttachments());
        return newSample;
    }

    public static SampleUpdatesDTO convertToSampleUpdateDTO(Sample apiSample) {
        String[] parentIdentifiers;
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = apiSample.getSample();
        Set sampleParents = sample.getParents();
        if (apiSample.getUpdateDetails().isParentsUpdateRequested()) {
            parentIdentifiers = new String[sampleParents.size()];
            int i = 0;
            for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample parent : sampleParents) {
                parentIdentifiers[i++] = parent.getIdentifier();
            }
        } else {
            parentIdentifiers = null;
        }
        List<NewAttachment> attachments = apiSample.getNewAttachments();
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)sample.getIdentifier());
        String containerIdentifier = sample.getContainer() != null ? sample.getContainer().getIdentifier() : null;
        SampleUpdatesDTO sampleUpdate = new SampleUpdatesDTO(TechId.create((IIdHolder)sample), sample.getProperties(), ExperimentIdentifierFactory.tryGetExperimentIdentifier((ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample)sample), ProjectIdentifierFactory.tryGetProjectIdentifier((ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample)sample), attachments, sample.getVersion(), sampleIdentifier, containerIdentifier, parentIdentifiers);
        return sampleUpdate;
    }

    public static NewExternalData convertToNewExternalData(DataSetRegistrationDetails<?> registrationDetails, String dataStoreCode, StorageFormat storageFormat, String dataFileRelativePath) {
        NewContainerDataSet data;
        Object dataSetInformation = registrationDetails.getDataSetInformation();
        if (((DataSetInformation)dataSetInformation).isContainerDataSet()) {
            data = new NewContainerDataSet();
            data.setContainedDataSetCodes(((DataSetInformation)dataSetInformation).getContainedDataSetCodes());
            if (null != dataFileRelativePath) {
                throw new IllegalArgumentException("A data set can contain files or other data sets, but not both. The data set specification is invalid: " + dataSetInformation);
            }
        } else {
            if (((DataSetInformation)dataSetInformation).isLinkDataSet()) {
                throw new NotImplementedException();
            }
            data = new NewDataSet();
            data.setSpeedHint(((DataSetInformation)dataSetInformation).getSpeedHint());
            BooleanOrUnknown isCompleteFlag = ((DataSetInformation)dataSetInformation).getIsCompleteFlag();
            data.setComplete(isCompleteFlag);
            data.setLocatorType(registrationDetails.getLocatorType());
            data.setShareId(((DataSetInformation)dataSetInformation).getShareId());
            data.setLocation(dataFileRelativePath.substring(data.getShareId().length() + 1));
            data.setFileFormatType(registrationDetails.getFileFormatType());
        }
        data.setUserId(((DataSetInformation)dataSetInformation).getUploadingUserIdOrNull());
        data.setUserEMail(((DataSetInformation)dataSetInformation).tryGetUploadingUserEmail());
        data.setExtractableData(((DataSetInformation)dataSetInformation).getExtractableData());
        data.setDataSetType(registrationDetails.getDataSetType());
        data.setDataSetKind(registrationDetails.getDataSetKind());
        data.setMeasured(registrationDetails.isMeasuredData());
        data.setDataStoreCode(dataStoreCode);
        data.setExperimentIdentifierOrNull(((DataSetInformation)dataSetInformation).getExperimentIdentifier());
        data.setSampleIdentifierOrNull(((DataSetInformation)dataSetInformation).getSampleIdentifier());
        data.setSamplePermIdOrNull(ConversionUtils.getSamplePermIdOrNull(dataSetInformation));
        data.setParentDataSetCodes(((DataSetInformation)dataSetInformation).getParentDataSetCodes());
        data.setStorageFormat(storageFormat);
        List newProperties = ((DataSetInformation)dataSetInformation).getExtractableData().getDataSetProperties();
        data.getExtractableData().setDataSetProperties(newProperties);
        return data;
    }

    private static String getSamplePermIdOrNull(DataSetInformation dataSetInformation) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = dataSetInformation.tryToGetSample();
        return sample == null ? null : sample.getPermId();
    }

    public static NewLinkDataSet convertToNewLinkDataSet(DataSetRegistrationDetails<?> registrationDetails, String dataStoreCode) {
        Object dataSetInformation = registrationDetails.getDataSetInformation();
        NewLinkDataSet data = new NewLinkDataSet();
        data.setExternalDataManagementSystemCode(((DataSetInformation)dataSetInformation).getExternalDataManagementSystem());
        data.setExternalCode(((DataSetInformation)dataSetInformation).getExternalCode());
        data.setUserId(((DataSetInformation)dataSetInformation).getUploadingUserIdOrNull());
        data.setUserEMail(((DataSetInformation)dataSetInformation).tryGetUploadingUserEmail());
        data.setExtractableData(((DataSetInformation)dataSetInformation).getExtractableData());
        data.setDataSetType(registrationDetails.getDataSetType());
        data.setDataSetKind(registrationDetails.getDataSetKind());
        data.setMeasured(registrationDetails.isMeasuredData());
        data.setDataStoreCode(dataStoreCode);
        data.setExperimentIdentifierOrNull(((DataSetInformation)dataSetInformation).getExperimentIdentifier());
        data.setSampleIdentifierOrNull(((DataSetInformation)dataSetInformation).getSampleIdentifier());
        data.setParentDataSetCodes(((DataSetInformation)dataSetInformation).getParentDataSetCodes());
        List newProperties = ((DataSetInformation)dataSetInformation).getExtractableData().getDataSetProperties();
        data.getExtractableData().setDataSetProperties(newProperties);
        return data;
    }

    public static NewContainerDataSet convertToNewContainerDataSet(DataSetRegistrationDetails<?> registrationDetails, String dataStoreCode) {
        Object dataSetInformation = registrationDetails.getDataSetInformation();
        NewContainerDataSet data = new NewContainerDataSet();
        data.setContainedDataSetCodes(((DataSetInformation)dataSetInformation).getContainedDataSetCodes());
        data.setUserId(((DataSetInformation)dataSetInformation).getUploadingUserIdOrNull());
        data.setUserEMail(((DataSetInformation)dataSetInformation).tryGetUploadingUserEmail());
        data.setExtractableData(((DataSetInformation)dataSetInformation).getExtractableData());
        data.setDataSetType(registrationDetails.getDataSetType());
        data.setDataSetKind(registrationDetails.getDataSetKind());
        data.setMeasured(registrationDetails.isMeasuredData());
        data.setDataStoreCode(dataStoreCode);
        data.setExperimentIdentifierOrNull(((DataSetInformation)dataSetInformation).getExperimentIdentifier());
        data.setSampleIdentifierOrNull(((DataSetInformation)dataSetInformation).getSampleIdentifier());
        data.setParentDataSetCodes(((DataSetInformation)dataSetInformation).getParentDataSetCodes());
        List newProperties = ((DataSetInformation)dataSetInformation).getExtractableData().getDataSetProperties();
        data.getExtractableData().setDataSetProperties(newProperties);
        return data;
    }

    public static NewSpace convertToNewSpace(Space apiSpace) {
        return new NewSpace(apiSpace.getSpaceCode(), apiSpace.getDescription(), apiSpace.getSpaceAdminUserId());
    }

    public static NewProject convertToNewProject(Project apiProject) {
        NewProject newProject = new NewProject(apiProject.getProjectIdentifier(), apiProject.getDescription());
        newProject.setAttachments(apiProject.getNewAttachments());
        return newProject;
    }

    public static ProjectUpdatesDTO convertToProjectUpdateDTO(Project apiProject) {
        ProjectUpdatesDTO projectUpdate = new ProjectUpdatesDTO();
        projectUpdate.setIdentifier(apiProject.getProjectIdentifier());
        projectUpdate.setTechId(new TechId(apiProject.getId()));
        projectUpdate.setDescription(apiProject.getDescription());
        projectUpdate.setAttachments(apiProject.getNewAttachments());
        projectUpdate.setVersion(apiProject.getProject().getVersion());
        return projectUpdate;
    }

    public static DataSetUpdatesDTO convertToDataSetUpdatesDTO(DataSetUpdatable dataSet) {
        String identifierString;
        AbstractExternalData externalData = dataSet.getExternalData();
        DataSetUpdatesDTO dataSetUpdate = new DataSetUpdatesDTO();
        dataSetUpdate.setDatasetId(new TechId((IIdAndCodeHolder)externalData));
        dataSetUpdate.setVersion(externalData.getVersion());
        dataSetUpdate.setFileFormatTypeCode(dataSet.getFileFormatType());
        dataSetUpdate.setProperties(externalData.getProperties());
        if (externalData.getExperiment() != null) {
            identifierString = externalData.getExperiment().getIdentifier();
            ExperimentIdentifier experimentIdentifier = ExperimentIdentifierFactory.parse((String)identifierString);
            dataSetUpdate.setExperimentIdentifierOrNull(experimentIdentifier);
        }
        if (externalData.getSample() != null) {
            identifierString = externalData.getSampleIdentifier();
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)identifierString);
            dataSetUpdate.setSampleIdentifierOrNull(sampleIdentifier);
        }
        if (externalData.isContainer()) {
            ContainerDataSet container = externalData.tryGetAsContainerDataSet();
            String[] containedCodes = Code.extractCodesToArray((Collection)container.getContainedDataSets());
            dataSetUpdate.setModifiedContainedDatasetCodesOrNull(containedCodes);
        }
        if (externalData.isLinkData()) {
            LinkDataSet link = externalData.tryGetAsLinkDataSet();
            dataSetUpdate.setExternalCode(link.getExternalCode());
            dataSetUpdate.setExternalDataManagementSystemCode(link.getExternalDataManagementSystem().getCode());
        }
        return dataSetUpdate;
    }

    public static DataSetBatchUpdatesDTO convertToDataSetBatchUpdatesDTO(DataSetUpdatable dataSet) {
        return ConversionUtils.enrichUpdatesWithInformation(dataSet, dataSet.getUpdates());
    }

    private static DataSetBatchUpdatesDTO enrichUpdatesWithInformation(DataSetUpdatable dataSet, DataSetBatchUpdatesDTO dataSetUpdate) {
        String identifierString;
        AbstractExternalData externalData = dataSet.getExternalData();
        dataSetUpdate.setDatasetId(new TechId((IIdAndCodeHolder)externalData));
        dataSetUpdate.setVersion(externalData.getVersion());
        dataSetUpdate.setFileFormatTypeCode(dataSet.getFileFormatType());
        dataSetUpdate.setProperties(externalData.getProperties());
        if (externalData.getExperiment() != null) {
            identifierString = externalData.getExperiment().getIdentifier();
            ExperimentIdentifier experimentIdentifier = ExperimentIdentifierFactory.parse((String)identifierString);
            dataSetUpdate.setExperimentIdentifierOrNull(experimentIdentifier);
        }
        if (externalData.getSample() != null) {
            identifierString = externalData.getSampleIdentifier();
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)identifierString);
            dataSetUpdate.setSampleIdentifierOrNull(sampleIdentifier);
        }
        if (externalData.isContainer()) {
            ContainerDataSet container = externalData.tryGetAsContainerDataSet();
            String[] containedCodes = Code.extractCodesToArray((Collection)container.getContainedDataSets());
            dataSetUpdate.setModifiedContainedDatasetCodesOrNull(containedCodes);
        }
        if (externalData.isLinkData()) {
            dataSetUpdate.setExternalCode(dataSet.getExternalCode());
            dataSetUpdate.setExternalDataManagementSystemCode(dataSet.getExternalDataManagementSystem().getCode());
        }
        String[] parentCodes = Code.extractCodesToArray((Collection)externalData.getParents());
        dataSetUpdate.setModifiedParentDatasetCodesOrNull(parentCodes);
        return dataSetUpdate;
    }

    public static NewMaterial convertToNewMaterial(Material material) {
        NewMaterial newMaterial = new NewMaterial(material.getCode());
        IEntityProperty[] properties = material.getMaterial().getProperties().toArray(new IEntityProperty[0]);
        newMaterial.setProperties(properties);
        return newMaterial;
    }

    public static MaterialUpdateDTO convertToMaterialUpdateDTO(Material material) {
        return new MaterialUpdateDTO(new TechId(material.getMaterial().getId()), material.getMaterial().getProperties(), material.getMaterial().getModificationDate());
    }

    public static NewMetaproject convertToNewMetaproject(Metaproject metaproject) {
        NewMetaproject newMetaproject = new NewMetaproject(metaproject.getName(), metaproject.getDescription(), metaproject.getOwnerId());
        newMetaproject.setEntities((Collection)Translator.translate(metaproject.getAddedEntities()));
        return newMetaproject;
    }

    public static MetaprojectUpdatesDTO convertToMetaprojectUpdatesDTO(Metaproject metaproject) {
        MetaprojectUpdatesDTO update = new MetaprojectUpdatesDTO();
        update.setMetaprojectId(new TechId(metaproject.getId()));
        update.setDescription(metaproject.getDescription());
        update.setAddedEntities((Collection)Translator.translate(metaproject.getAddedEntities()));
        update.setRemovedEntities((Collection)Translator.translate(metaproject.getRemovedEntities()));
        return update;
    }

    static NewAttachment createAttachment(String filePath, String title, String description, byte[] content) {
        NewAttachment newAttachment = new NewAttachment();
        newAttachment.setFilePath(filePath);
        newAttachment.setTitle(title);
        newAttachment.setDescription(description);
        newAttachment.setContent(content);
        return newAttachment;
    }

    public static List<IMetaprojectImmutable> convertToMetaprojectsImmutable(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject> metaprojects) {
        Collection converted = CollectionUtils.collect(metaprojects, (Transformer)new Transformer<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject, IMetaprojectImmutable>(){

            public IMetaprojectImmutable transform(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject input) {
                return new MetaprojectImmutable(input);
            }
        });
        return new LinkedList<IMetaprojectImmutable>(converted);
    }
}

