/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.etlserver.registrator.api.v2.ISample;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ConversionUtils;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ProjectImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IProjectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Sample
extends SampleImmutable
implements ISample {
    private final List<NewAttachment> newAttachments;
    private final SampleBatchUpdateDetails updateDetails;

    private static ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample buildSampleWithIdentifier(String identifier) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = new ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample();
        sample.setProperties(new ArrayList());
        sample.setIdentifier(identifier);
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)identifier);
        sample.setCode(sampleIdentifier.getSampleCode());
        String sampleSubCode = sampleIdentifier.getSampleSubCode();
        sample.setSubCode(sampleSubCode);
        if (sampleIdentifier.isProjectLevel()) {
            ProjectIdentifier projectLevel = sampleIdentifier.getProjectLevel();
            Space space = new Space();
            space.setCode(projectLevel.getSpaceCode());
            Project project = new Project();
            project.setSpace(space);
            project.setCode(projectLevel.getProjectCode());
            sample.setSpace(space);
            sample.setProject(project);
        } else if (sampleIdentifier.isSpaceLevel()) {
            Space space = new Space();
            SpaceIdentifier spaceLevel = sampleIdentifier.getSpaceLevel();
            space.setCode(spaceLevel.getSpaceCode());
            sample.setSpace(space);
        }
        return sample;
    }

    public Sample(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample) {
        super(sample);
        this.updateDetails = new SampleBatchUpdateDetails();
        this.newAttachments = new ArrayList<NewAttachment>();
        this.initializeUpdateDetails();
    }

    public Sample(SampleImmutable sample) {
        this(sample.getSample());
    }

    public Sample(String sampleIdentifier, String permId) {
        super(Sample.buildSampleWithIdentifier(sampleIdentifier), false);
        this.getSample().setPermId(permId);
        this.updateDetails = new SampleBatchUpdateDetails();
        this.newAttachments = new ArrayList<NewAttachment>();
        this.initializeUpdateDetails();
    }

    private void initializeUpdateDetails() {
        this.updateDetails.setExperimentUpdateRequested(false);
        this.updateDetails.setContainerUpdateRequested(false);
        this.updateDetails.setParentsUpdateRequested(false);
        this.updateDetails.setPropertiesToUpdate(new HashSet());
    }

    @Override
    public void setExperiment(IExperimentImmutable experiment) {
        ExperimentImmutable exp = (ExperimentImmutable)experiment;
        if (exp == null) {
            this.getSample().setExperiment(null);
        } else {
            this.getSample().setExperiment(exp.getExperiment());
        }
        this.updateDetails.setExperimentUpdateRequested(true);
    }

    @Override
    public void setProject(IProjectImmutable project) {
        ProjectImmutable proj = (ProjectImmutable)project;
        if (proj == null) {
            this.getSample().setProject(null);
        } else {
            this.getSample().setProject(proj.getProject());
        }
    }

    @Override
    public void setPropertyValue(String propertyCode, String propertyValue) {
        EntityHelper.createOrUpdateProperty((IEntityPropertiesHolder)this.getSample(), (String)propertyCode, (String)propertyValue);
        Set propertiesToUpdate = this.updateDetails.getPropertiesToUpdate();
        propertiesToUpdate.add(propertyCode);
    }

    @Override
    public void setSampleType(String type) {
        SampleType sampleType = new SampleType();
        sampleType.setCode(type);
        this.getSample().setSampleType(sampleType);
    }

    @Override
    public void setContainer(ISampleImmutable container) {
        SampleImmutable containerImpl = (SampleImmutable)container;
        this.getSample().setContainer(containerImpl.getSample());
        this.updateDetails.setContainerUpdateRequested(true);
    }

    @Override
    public void setParentSampleIdentifiers(List<String> parentSampleIdentifiers) {
        HashSet<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> parents = new HashSet<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample>();
        for (String identifier : parentSampleIdentifiers) {
            parents.add(Sample.buildSampleWithIdentifier(identifier));
        }
        this.getSample().setParents(parents);
        this.updateDetails.setParentsUpdateRequested(true);
    }

    @Override
    public void addAttachment(String filePath, String title, String description, byte[] content) {
        this.newAttachments.add(ConversionUtils.createAttachment(filePath, title, description, content));
    }

    List<NewAttachment> getNewAttachments() {
        return this.newAttachments;
    }

    SampleBatchUpdateDetails getUpdateDetails() {
        return this.updateDetails;
    }
}

