/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.etlserver.DssRegistrationLogDirectoryHelper;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPersistentMap;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.api.impl.RollbackStack;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class AbstractRecoveryState<T extends DataSetInformation>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File dssRegistrationLogFile;
    private File rollbackStackCommandsFile;
    private DataSetFile incomingDataSetFile;
    private DataSetRegistrationPersistentMap persistentMap;

    public AbstractRecoveryState() {
    }

    public AbstractRecoveryState(DssRegistrationLogger logger, IRollbackStack rollbackStack, DataSetFile incomingDataSetFile, DataSetRegistrationPersistentMap persistentMap) {
        this.dssRegistrationLogFile = logger.getFile();
        this.rollbackStackCommandsFile = ((RollbackStack)rollbackStack).getCommandsFile();
        this.incomingDataSetFile = incomingDataSetFile;
        this.persistentMap = persistentMap;
    }

    public DataSetFile getIncomingDataSetFile() {
        return this.incomingDataSetFile;
    }

    public DssRegistrationLogger getRegistrationLogger(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState state) {
        DssRegistrationLogDirectoryHelper helper = new DssRegistrationLogDirectoryHelper(state.getGlobalState().getDssRegistrationLogDir());
        DssRegistrationLogger logger = new DssRegistrationLogger(this.dssRegistrationLogFile, helper, state.getFileOperations());
        return logger;
    }

    public abstract ArrayList<DataSetStorageAlgorithm<T>> getDataSetStorageAlgorithms(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState var1);

    public RollbackStack getRollbackStack() {
        return new RollbackStack(this.rollbackStackCommandsFile);
    }

    public DataSetRegistrationPersistentMap getPersistentMap() {
        return this.persistentMap;
    }
}

