/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.registrator.recovery.IDataSetStorageRecoveryAlgorithmWithState;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.ContainerDataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.LinkDataSetStorageAlgorithm;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import java.io.File;
import java.io.Serializable;

public class DataSetStorageRecoveryAlgorithm<T extends DataSetInformation>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DataStoreStrategyKey dssKey;
    private final File incomingDataSetFile;
    private final File stagingDirectory;
    private final File preCommitDirectory;
    private final String dataStoreCode;
    private final T dataSetInformation;
    private final DataSetStorageAlgorithm.DataSetStoragePaths dataSetStoragePaths;
    private final DataSetKind dataSetKind;

    public DataSetStorageRecoveryAlgorithm(T dataSetInformation, DataStoreStrategyKey dataStoreStrategyKey, File incomingDataSetFile, File stagingDirectory, File preCommitDirectory, String dataStoreCode, DataSetStorageAlgorithm.DataSetStoragePaths dataSetStoragePaths, DataSetKind dataSetKind) {
        this.dataSetInformation = dataSetInformation;
        this.dssKey = dataStoreStrategyKey;
        this.incomingDataSetFile = incomingDataSetFile;
        this.stagingDirectory = stagingDirectory;
        this.preCommitDirectory = preCommitDirectory;
        this.dataStoreCode = dataStoreCode;
        this.dataSetStoragePaths = dataSetStoragePaths;
        this.dataSetKind = dataSetKind;
    }

    public String getDataSetCode() {
        return ((DataSetInformation)this.dataSetInformation).getDataSetCode();
    }

    public T getDataSetInformation() {
        return this.dataSetInformation;
    }

    public DataStoreStrategyKey getDataStoreStrategyKey() {
        return this.dssKey;
    }

    public File getIncomingDataSetFile() {
        return this.incomingDataSetFile;
    }

    public File getStagingDirectory() {
        return this.stagingDirectory;
    }

    public File getPreCommitDirectory() {
        return this.preCommitDirectory;
    }

    public String getDataStoreCode() {
        return this.dataStoreCode;
    }

    public DataSetStorageAlgorithm.DataSetStoragePaths getDataSetStoragePaths() {
        return this.dataSetStoragePaths;
    }

    public DataSetKind getDataSetKind() {
        return this.dataSetKind;
    }

    public DataSetStorageAlgorithm<T> recoverDataSetStorageAlgorithm(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState state, IDataSetStorageRecoveryAlgorithmWithState<T> algorithm) {
        IDataStoreStrategy dataStoreStrategy = state.getDataStrategyStore().getDataStoreStrategy(this.getDataStoreStrategyKey());
        IMailClient mailClient = state.getGlobalState().getMailClient();
        IFileOperations fileOperations = state.getFileOperations();
        IStorageProcessorTransactional storageProcessor = state.getStorageProcessor();
        switch (this.getDataSetKind()) {
            case CONTAINER: {
                return new ContainerDataSetStorageAlgorithm(dataStoreStrategy, storageProcessor, fileOperations, mailClient, this);
            }
            case LINK: {
                return new LinkDataSetStorageAlgorithm(dataStoreStrategy, storageProcessor, fileOperations, mailClient, this);
            }
            case PHYSICAL: {
                return algorithm.createExternalDataSetStorageAlgorithm(dataStoreStrategy, storageProcessor, fileOperations, mailClient);
            }
        }
        throw new IllegalStateException("Unknown data set kind " + this.getDataSetKind());
    }
}

