/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.serviceconversation.client.ServiceExecutionException;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.recovery.AbstractRecoveryState;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStoragePrecommitRecoveryState;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryInfo;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageStorageRecoveryState;
import ch.systemsx.cisd.etlserver.registrator.recovery.IDataSetStorageRecoveryManager;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;

public class DataSetStorageRecoveryManager
implements IDataSetStorageRecoveryManager {
    private static final String PRECOMMIT_SERIALIZED = ".PRECOMMIT_SERIALIZED";
    private static final String PROCESSING_MARKER = ".PROCESSING_MARKER";
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetStorageRecoveryManager.class);
    private File dropboxRecoveryStateDir;
    private File recoveryMarkerFilesDir;
    private int maxRetryCount = 50;
    private int retryPeriodInSeconds = 60;

    @Override
    public <T extends DataSetInformation> void checkpointPrecommittedState(TechId registrationId, DataSetStorageAlgorithmRunner<T> runner) {
        DataSetFile incoming = runner.getIncomingDataSetFile();
        DataSetStoragePrecommitRecoveryState<T> recoveryState = new DataSetStoragePrecommitRecoveryState<T>(registrationId, runner.getDataSetStorageAlgorithms(), runner.getDssRegistrationLogger(), runner.getRollbackStack(), incoming, runner.getRegistrationContext().getPersistentMap());
        this.checkpointState(runner, recoveryState, DataSetStorageRecoveryInfo.RecoveryStage.PRECOMMIT);
    }

    @Override
    public <T extends DataSetInformation> void checkpointPrecommittedStateAfterPostRegistrationHook(DataSetStorageAlgorithmRunner<T> runner) {
        DataSetFile incoming = runner.getIncomingDataSetFile();
        DataSetStoragePrecommitRecoveryState<T> recoveryState = new DataSetStoragePrecommitRecoveryState<T>(null, runner.getDataSetStorageAlgorithms(), runner.getDssRegistrationLogger(), runner.getRollbackStack(), incoming, runner.getRegistrationContext().getPersistentMap());
        this.checkpointState(runner, recoveryState, DataSetStorageRecoveryInfo.RecoveryStage.POST_REGISTRATION_HOOK_EXECUTED);
    }

    @Override
    public <T extends DataSetInformation> void checkpointStoredStateBeforeStorageConfirmation(DataSetStorageAlgorithmRunner<T> runner) {
        DataSetFile incoming = runner.getIncomingDataSetFile();
        DataSetStorageStorageRecoveryState<T> recoveryState = new DataSetStorageStorageRecoveryState<T>(runner.getDataSetStorageAlgorithms(), runner.getDssRegistrationLogger(), runner.getRollbackStack(), incoming, runner.getRegistrationContext().getPersistentMap());
        this.checkpointState(runner, recoveryState, DataSetStorageRecoveryInfo.RecoveryStage.STORAGE_COMPLETED);
    }

    public <T extends DataSetInformation> void checkpointState(DataSetStorageAlgorithmRunner<T> runner, Serializable recoveryState, DataSetStorageRecoveryInfo.RecoveryStage recoveryStage) {
        File serializedFile = this.getSerializedFile(runner);
        runner.getRollbackStack().setLockedState(true);
        FileUtilities.writeToFile((File)serializedFile, (Serializable)recoveryState);
        File processingMarkerFile = this.getProcessingMarkerFile(runner);
        DataSetStorageRecoveryInfo info = new DataSetStorageRecoveryInfo(serializedFile, new Date(), 0, recoveryStage);
        info.writeToFile(processingMarkerFile);
        operationLog.info((Object)("Store recovery checkpoint with markerfile " + processingMarkerFile));
    }

    @Override
    public <T extends DataSetInformation> void removeCheckpoint(DataSetStorageAlgorithmRunner<T> runner) {
        this.cleanup(runner);
    }

    private <T extends DataSetInformation> File getProcessingMarkerFile(DataSetStorageAlgorithmRunner<T> runner) {
        return this.getProcessingMarkerFile(runner.getIncomingDataSetFile().getRealIncomingFile());
    }

    @Override
    public File getProcessingMarkerFile(File incoming) {
        return new File(this.recoveryMarkerFilesDir, incoming.getName() + PROCESSING_MARKER);
    }

    private <T extends DataSetInformation> File getSerializedFile(DataSetStorageAlgorithmRunner<T> runner) {
        DataSetFile incoming = runner.getIncomingDataSetFile();
        String incomingFileName = incoming.getRealIncomingFile().getName();
        return new File(this.dropboxRecoveryStateDir, incomingFileName + PRECOMMIT_SERIALIZED);
    }

    @Override
    public DataSetStorageRecoveryInfo getRecoveryFileFromMarker(File markerFile) {
        return DataSetStorageRecoveryInfo.loadFromFile(markerFile);
    }

    @Override
    public <T extends DataSetInformation> AbstractRecoveryState<T> extractRecoveryCheckpoint(File markerFile) {
        DataSetStorageRecoveryInfo info = this.getRecoveryFileFromMarker(markerFile);
        return (AbstractRecoveryState)FileUtilities.loadToObject((File)info.getRecoveryStateFile(), DataSetStoragePrecommitRecoveryState.class);
    }

    @Override
    public <T extends DataSetInformation> void registrationCompleted(DataSetStorageAlgorithmRunner<T> runner) {
        this.cleanup(runner);
    }

    public <T extends DataSetInformation> void cleanup(DataSetStorageAlgorithmRunner<T> runner) {
        File markerFile = this.getProcessingMarkerFile(runner);
        File recoveryState = this.getSerializedFile(runner);
        operationLog.info((Object)("Cleanup recovery with marker file " + markerFile));
        runner.getRollbackStack().setLockedState(false);
        FileUtilities.delete((File)markerFile);
        FileUtilities.delete((File)recoveryState);
    }

    @Override
    public boolean canRecoverFromError(Throwable ex) {
        if (ex instanceof HighLevelException) {
            return HighLevelException.isRetriable((Throwable)ex);
        }
        if (ex instanceof ServiceExecutionException) {
            try {
                ServiceExecutionException sex = (ServiceExecutionException)ex;
                String desc = sex.getDescription();
                String exceptionClassname = desc.substring(0, desc.indexOf(":"));
                Class<?> exceptionClass = Class.forName(exceptionClassname);
                if (HighLevelException.class.isAssignableFrom(exceptionClass)) {
                    return EnvironmentFailureException.class.isAssignableFrom(exceptionClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void setDropboxRecoveryStateDir(File dropboxRecoveryStateDir) {
        this.dropboxRecoveryStateDir = dropboxRecoveryStateDir;
    }

    @Override
    public void setRecoveryMarkerFilesDir(File recoveryMarkerFileDir) {
        this.recoveryMarkerFilesDir = recoveryMarkerFileDir;
    }

    @Override
    public void setMaximumRertyCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public int getMaximumRertyCount() {
        return this.maxRetryCount;
    }

    @Override
    public int getRetryPeriodInSeconds() {
        return this.retryPeriodInSeconds;
    }

    @Override
    public void setRetryPeriodInSeconds(int retryPeriodInSeconds) {
        this.retryPeriodInSeconds = retryPeriodInSeconds;
    }
}

