/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v1;

import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSet;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.types.DataSetTypeCode;
import java.io.File;
import java.util.List;

public abstract class AbstractDataSetRegistrationDetailsFactory<T extends DataSetInformation>
implements IDataSetRegistrationDetailsFactory<T> {
    protected final AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState;
    protected final DataSetInformation userProvidedDataSetInformationOrNull;

    public AbstractDataSetRegistrationDetailsFactory(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState, DataSetInformation userProvidedDataSetInformationOrNull) {
        this.registratorState = registratorState;
        this.userProvidedDataSetInformationOrNull = userProvidedDataSetInformationOrNull;
    }

    @Override
    public String getUserIdOrNull() {
        return null == this.userProvidedDataSetInformationOrNull ? null : this.userProvidedDataSetInformationOrNull.getUploadingUserIdOrNull();
    }

    @Override
    public DataSetRegistrationDetails<T> createDataSetRegistrationDetails() {
        DataSetRegistrationDetails<T> registrationDetails = new DataSetRegistrationDetails<T>();
        T dataSetInfo = this.createDataSetInformation();
        if (null != this.userProvidedDataSetInformationOrNull) {
            this.applyUserProvidedValues(dataSetInfo);
            ((DataSetInformation)dataSetInfo).setUploadingUserId(this.userProvidedDataSetInformationOrNull.getUploadingUserIdOrNull());
        }
        if (null == ((DataSetInformation)dataSetInfo).getDataSetType()) {
            this.setDataSetTypeToDefaultValue(dataSetInfo);
        }
        if (null == ((DataSetInformation)dataSetInfo).getDataSetKind()) {
            this.setDataSetKindToDefaultValue(dataSetInfo);
        }
        this.setDatabaseInstance((DataSetInformation)dataSetInfo);
        registrationDetails.setDataSetInformation(dataSetInfo);
        return registrationDetails;
    }

    @Override
    public DataSet<T> createDataSet(DataSetRegistrationDetails<T> registrationDetails, File stagingFile) {
        IEncapsulatedOpenBISService service = this.registratorState.getGlobalState().getOpenBisService();
        return new DataSet<T>(registrationDetails, stagingFile, service);
    }

    protected void applyUserProvidedValues(T dataSetInfo) {
        List<NewProperty> props;
        DataSetKind kind;
        DataSetType type;
        ExperimentIdentifier experimentId;
        SampleIdentifier sampleId = this.userProvidedDataSetInformationOrNull.getSampleIdentifier();
        if (null != sampleId) {
            ((DataSetInformation)dataSetInfo).setSampleIdentifier(sampleId);
        }
        if (null != this.userProvidedDataSetInformationOrNull.tryToGetSample()) {
            ((DataSetInformation)dataSetInfo).setSample(this.userProvidedDataSetInformationOrNull.tryToGetSample());
        }
        if (null != (experimentId = this.userProvidedDataSetInformationOrNull.getExperimentIdentifier())) {
            ((DataSetInformation)dataSetInfo).setExperimentIdentifier(experimentId);
        }
        if (null != this.userProvidedDataSetInformationOrNull.tryToGetExperiment()) {
            ((DataSetInformation)dataSetInfo).setExperiment(this.userProvidedDataSetInformationOrNull.tryToGetExperiment());
        }
        if (null != (type = this.userProvidedDataSetInformationOrNull.getDataSetType())) {
            ((DataSetInformation)dataSetInfo).setDataSetType(type);
        }
        if (null != (kind = this.userProvidedDataSetInformationOrNull.getDataSetKind())) {
            ((DataSetInformation)dataSetInfo).setDataSetKind(kind);
        }
        if (!(props = this.userProvidedDataSetInformationOrNull.getDataSetProperties()).isEmpty()) {
            ((DataSetInformation)dataSetInfo).setDataSetProperties(props);
        }
        if (this.userProvidedDataSetInformationOrNull.getParentDataSetCodes() != null) {
            ((DataSetInformation)dataSetInfo).setParentDataSetCodes(this.userProvidedDataSetInformationOrNull.getParentDataSetCodes());
        }
    }

    protected void setDataSetTypeToDefaultValue(T dataSetInfo) {
        ((DataSetInformation)dataSetInfo).setDataSetType(new DataSetType(DataSetTypeCode.UNKNOWN.getCode()));
    }

    protected void setDataSetKindToDefaultValue(T dataSetInfo) {
        ((DataSetInformation)dataSetInfo).setDataSetKind(DataSetKind.PHYSICAL);
    }

    protected final void setDatabaseInstance(DataSetInformation dataSetInfo) {
        dataSetInfo.setInstanceUUID(this.registratorState.getHomeDatabaseInstance().getUuid());
    }

    protected abstract T createDataSetInformation();
}

