/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v1;

import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IJavaDataSetRegistrationDropboxV1;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.etlserver.registrator.v1.JythonTopLevelDataSetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.List;
import org.python.core.PyException;
import org.python.core.PyObject;

public abstract class AbstractProgrammableTopLevelDataSetHandler<T extends DataSetInformation>
extends AbstractOmniscientTopLevelDataSetRegistrator<T> {
    protected AbstractProgrammableTopLevelDataSetHandler(TopLevelDataSetRegistratorGlobalState globalState) {
        super(globalState);
    }

    public abstract boolean shouldNotAddToFaultyPathsOrNull(File var1);

    @Override
    protected abstract void handleDataSet(DataSetFile var1, DataSetRegistrationService<T> var2) throws Throwable;

    protected void waitUntilApplicationIsReady(DataSetFile incomingDataSetFile) {
        while (DssRegistrationHealthMonitor.getInstance().checkHealthState(incomingDataSetFile.getRealIncomingFile().getParentFile()).isUnavailable()) {
            this.waitTheRetryPeriod(10);
        }
    }

    protected void waitTheRetryPeriod(int retryPeriod) {
        ConcurrencyUtilities.sleep((long)(retryPeriod * 1000));
    }

    @Override
    public void didRollbackTransaction(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithmRunner, Throwable ex) {
        try {
            this.getV2DropboxProgram(service).rollbackPreRegistration(transaction.getRegistrationContext(), ex);
        }
        catch (NotImplementedException e) {
            IJavaDataSetRegistrationDropboxV1<T> v1Dropbox = this.getV1DropboxProgram();
            try {
                v1Dropbox.rollbackTransaction(service, transaction, algorithmRunner, ex);
            }
            catch (NotImplementedException exc) {
                try {
                    v1Dropbox.rollbackService(service, ex);
                }
                catch (NotImplementedException notImplementedException) {
                    // empty catch block
                }
            }
        }
        super.didRollbackTransaction(service, transaction, algorithmRunner, ex);
    }

    @Override
    public void didCommitTransaction(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction) {
        super.didCommitTransaction(service, transaction);
        try {
            this.getV2DropboxProgram(service).postStorage(transaction.getRegistrationContext());
        }
        catch (NotImplementedException e) {
            try {
                this.getV1DropboxProgram().commitTransaction(service, transaction);
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void didPreRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
        super.didPreRegistration(service, registrationContextHolder);
        try {
            this.getV2DropboxProgram(service).preMetadataRegistration(registrationContextHolder.getRegistrationContext());
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    @Override
    public void didPostRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
        super.didPostRegistration(service, registrationContextHolder);
        try {
            this.getV2DropboxProgram(service).postMetadataRegistration(registrationContextHolder.getRegistrationContext());
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    @Override
    public void didEncounterSecondaryTransactionErrors(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, List<SecondaryTransactionFailure> secondaryErrors) {
        super.didEncounterSecondaryTransactionErrors(service, transaction, secondaryErrors);
        try {
            this.getV1DropboxProgram().didEncounterSecondaryTransactionErrors(service, transaction, secondaryErrors);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    protected abstract IJavaDataSetRegistrationDropboxV2 getV2DropboxProgram(DataSetRegistrationService<T> var1);

    protected IDataSetRegistrationDetailsFactory<T> createObjectFactory(DataSetInformation userProvidedDataSetInformationOrNull) {
        return new JythonTopLevelDataSetHandler.ProgrammableDropboxObjectFactory<DataSetInformation>(this.getRegistratorState(), userProvidedDataSetInformationOrNull){

            @Override
            protected DataSetInformation createDataSetInformation() {
                return new DataSetInformation();
            }
        };
    }

    @Override
    protected DataSetRegistrationService<T> createDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return this.createJythonDataSetRegistrationService(incomingDataSetFile, callerDataSetInformationOrNull, cleanAfterwardsAction, delegate);
    }

    protected DataSetRegistrationService<T> createJythonDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return new DataSetRegistrationService<T>(this, incomingDataSetFile, this.createObjectFactory(userProvidedDataSetInformationOrNull), cleanAfterwardsAction, delegate);
    }

    protected abstract IJavaDataSetRegistrationDropboxV1<T> getV1DropboxProgram();

    @Override
    protected Throwable asSerializableException(Throwable throwable) {
        if (throwable instanceof PyException) {
            PyObject value = ((PyException)throwable).value;
            return new RuntimeException((value == null ? "" : value + "\n") + throwable);
        }
        return super.asSerializableException(throwable);
    }

    static interface IRecoveryCleanupDelegate {
        public void execute(boolean var1, boolean var2);
    }
}

