/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v1;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.api.impl.MkdirsCommand;
import ch.systemsx.cisd.etlserver.registrator.api.impl.MoveFileCommand;
import ch.systemsx.cisd.etlserver.registrator.api.impl.NewFileCommand;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ConversionUtils;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public class DataSetStorageAlgorithm<T extends DataSetInformation> {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetStorageAlgorithm.class);
    private final File incomingDataSetFile;
    private final DataSetRegistrationDetails<? extends T> registrationDetails;
    private final T dataSetInformation;
    private final IDataStoreStrategy dataStoreStrategy;
    private final IStorageProcessorTransactional storageProcessor;
    private final String dataStoreCode;
    private final DataSetType dataSetType;
    private final File storeRoot;
    private final IFileOperations fileOperations;
    private final IMailClient mailClient;
    private final File stagingDirectory;
    private final File preCommitDirectory;
    private DataSetStorageAlgorithmState<T> state;

    public static File createBaseDirectory(IDataStoreStrategy strategy, File baseDir, IFileOperations fileOperations, DataSetInformation dataSetInfo, DataSetType dataSetType, File incomingDataSetFile) {
        File baseDirectory = strategy.getBaseDirectory(baseDir, dataSetInfo, dataSetType);
        baseDirectory.mkdirs();
        if (!fileOperations.isDirectory(baseDirectory)) {
            throw EnvironmentFailureException.fromTemplate((String)"Creating data set base directory '%s' for data set '%s' failed.", (Object[])new Object[]{baseDirectory.getAbsolutePath(), incomingDataSetFile});
        }
        return baseDirectory;
    }

    public static File createBaseDirectory(IDataStoreStrategy strategy, File baseDir, IFileOperations fileOperations, DataSetInformation dataSetInfo, DataSetType dataSetType, File incomingDataSetFile, IRollbackStack rollbackStack) {
        File baseDirectory = strategy.getBaseDirectory(baseDir, dataSetInfo, dataSetType);
        rollbackStack.pushAndExecuteCommand(new MkdirsCommand(baseDirectory.getAbsolutePath()));
        if (!fileOperations.isDirectory(baseDirectory)) {
            throw EnvironmentFailureException.fromTemplate((String)"Creating data set base directory '%s' for data set '%s' failed.", (Object[])new Object[]{baseDirectory.getAbsolutePath(), incomingDataSetFile});
        }
        return baseDirectory;
    }

    public DataSetStorageAlgorithm(File incomingDataSetFile, DataSetRegistrationDetails<? extends T> registrationDetails, IDataStoreStrategy dataStoreStrategy, IStorageProcessorTransactional storageProcessor, IDataSetValidator dataSetValidator, String dataStoreCode, IFileOperations fileOperations, IMailClient mailClient, File stagingDirectory, File precommitDirectory) {
        this.incomingDataSetFile = incomingDataSetFile;
        this.registrationDetails = registrationDetails;
        this.dataSetInformation = registrationDetails.getDataSetInformation();
        this.dataStoreStrategy = dataStoreStrategy;
        this.storageProcessor = storageProcessor;
        this.dataStoreCode = dataStoreCode;
        this.fileOperations = fileOperations;
        this.mailClient = mailClient;
        this.stagingDirectory = stagingDirectory;
        this.preCommitDirectory = precommitDirectory;
        this.storeRoot = storageProcessor.getStoreRootDirectory();
        this.dataSetType = registrationDetails.getDataSetType();
        assert (dataStoreStrategy.getKey() == DataStoreStrategyKey.IDENTIFIED) : "Data set must be associated with an experiment ";
        dataSetValidator.assertValidDataSet(this.dataSetType, incomingDataSetFile);
        this.state = new InitializedState(this);
    }

    public IStorageProcessorTransactional.IStorageProcessorTransaction prepare(IRollbackStack rollbackStack) {
        InitializedState initializedState = (InitializedState)this.state;
        initializedState.prepare(rollbackStack);
        this.state = new PreparedState(initializedState);
        return ((PreparedState)this.state).transaction;
    }

    public void preCommit() throws Throwable {
        PreparedState preparedState = (PreparedState)this.state;
        preparedState.storeDataInPrecommit();
        this.state = new PrecommittedState(preparedState);
    }

    public void moveToTheStore() throws Throwable {
        CommittedState committed = (CommittedState)this.state;
        committed.moveToTheStore();
        this.state = new StoredState(committed);
    }

    public void cleanPrecommitDirectory() {
        StoredState stored = (StoredState)this.state;
        stored.cleanPrecommitDirectory();
    }

    public void transitionToRolledbackState(Throwable throwable) {
        if (this.state instanceof PreparedState) {
            PreparedState preparedState = (PreparedState)this.state;
            if (preparedState.wasStoreDataAttempted()) {
                this.state = new PrecommittedState((PreparedState)this.state);
            } else {
                return;
            }
        }
        PrecommittedState storedState = (PrecommittedState)this.state;
        storedState.cleanUpMarkerFile();
        this.state = new RolledbackState(storedState, IStorageProcessorTransactional.UnstoreDataAction.LEAVE_UNTOUCHED, throwable);
    }

    public void transitionToUndoneState() {
        if (this.state instanceof PreparedState) {
            this.state = new UndoneState((PreparedState)this.state);
            return;
        }
        RolledbackState rolledbackState = (RolledbackState)this.state;
        this.state = new UndoneState(rolledbackState);
    }

    public void commitStorageProcessor() {
        PrecommittedState storedState = (PrecommittedState)this.state;
        storedState.commitStorageProcessor();
        this.state = new CommittedState(storedState);
    }

    public File getIncomingDataSetFile() {
        return this.incomingDataSetFile;
    }

    public T getDataSetInformation() {
        return this.dataSetInformation;
    }

    protected Logger getOperationLog() {
        return operationLog;
    }

    public NewExternalData createExternalData() {
        File dataFile = ((PrecommittedState)this.state).getStoredDirectory();
        String relativePath = FileUtilities.getRelativeFilePath((File)this.storeRoot, (File)dataFile);
        String absolutePath = dataFile.getAbsolutePath();
        assert (relativePath != null) : String.format("Target path '%s' is not relative to store root directory '%s'.", absolutePath, this.storeRoot.getAbsolutePath());
        StorageFormat storageFormat = this.storageProcessor.getStorageFormat();
        return ConversionUtils.convertToNewExternalData(this.registrationDetails, this.dataStoreCode, storageFormat, relativePath);
    }

    public String getSuccessRegistrationMessage() {
        return ((DataSetInformation)this.dataSetInformation).toString();
    }

    public String getFailureRegistrationMessage() {
        return "Error trying to register data set '" + this.incomingDataSetFile.getName() + "'.";
    }

    protected DataSetType getDataSetType() {
        return this.dataSetType;
    }

    protected IDataStoreStrategy getDataStoreStrategy() {
        return this.dataStoreStrategy;
    }

    protected File getStoreRoot() {
        return this.storeRoot;
    }

    protected IStorageProcessorTransactional getStorageProcessor() {
        return this.storageProcessor;
    }

    protected String getDataStoreCode() {
        return this.dataStoreCode;
    }

    protected DataSetRegistrationDetails<? extends T> getRegistrationDetails() {
        return this.registrationDetails;
    }

    public File getStagingDirectory() {
        return this.stagingDirectory;
    }

    public File getPreCommitDirectory() {
        return this.preCommitDirectory;
    }

    public File getStagingFile() {
        return new File(this.stagingDirectory, ((DataSetInformation)this.dataSetInformation).getDataSetCode());
    }

    public DataSetKind getDataSetKind() {
        return DataSetKind.PHYSICAL;
    }

    public static class DataSetStoragePaths
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final File stagingBaseDirectory;
        protected final File storeBaseDirectory;
        protected final File precommitBaseDirectory;

        public DataSetStoragePaths(File stagingBaseDirectory, File storeBaseDirectory, File precommitBaseDirectory) {
            this.stagingBaseDirectory = stagingBaseDirectory;
            this.storeBaseDirectory = storeBaseDirectory;
            this.precommitBaseDirectory = precommitBaseDirectory;
        }

        public File getStagingBaseDirectory() {
            return this.stagingBaseDirectory;
        }

        public File getStoreBaseDirectory() {
            return this.storeBaseDirectory;
        }

        public File getPrecommitBaseDirectory() {
            return this.precommitBaseDirectory;
        }
    }

    private static class UndoneState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        UndoneState(PreparedState<T> oldState) {
            super(oldState.storageAlgorithm);
        }

        UndoneState(RolledbackState<T> oldState) {
            super(oldState.storageAlgorithm);
        }
    }

    private static class RolledbackState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        public RolledbackState(PrecommittedState<T> oldState, IStorageProcessorTransactional.UnstoreDataAction action, Throwable throwable) {
            super(oldState.storageAlgorithm);
        }
    }

    private static class StoredState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        protected final DataSetStoragePaths storagePaths;

        StoredState(CommittedState<T> oldState) {
            super(oldState.storageAlgorithm);
            this.storagePaths = oldState.storagePaths;
        }

        public void cleanPrecommitDirectory() {
            this.storagePaths.precommitBaseDirectory.delete();
        }
    }

    private static class CommittedState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        protected final DataSetStoragePaths storagePaths;

        CommittedState(PrecommittedState<T> oldState) {
            super(oldState.storageAlgorithm);
            this.storagePaths = oldState.storagePaths;
            this.cleanUpStagingDirectory();
        }

        private void cleanUpStagingDirectory() {
            this.getFileOperations().delete(this.storagePaths.stagingBaseDirectory);
            if (this.storagePaths.stagingBaseDirectory.exists()) {
                operationLog.error((Object)("Staging directory '" + this.storagePaths.stagingBaseDirectory + "' could not be deleted."));
            }
        }

        private void moveToTheStore() {
            if (!this.storagePaths.precommitBaseDirectory.exists()) {
                FileNotFoundException ioException = new FileNotFoundException("Can't find precommit directory " + this.storagePaths.precommitBaseDirectory);
                throw new IOExceptionUnchecked((IOException)ioException);
            }
            File[] stagedFiles = this.storagePaths.precommitBaseDirectory.listFiles();
            if (null == stagedFiles) {
                return;
            }
            for (File stagedFile : stagedFiles) {
                new MoveFileCommand(this.storagePaths.precommitBaseDirectory.getAbsolutePath(), stagedFile.getName(), this.storagePaths.storeBaseDirectory.getAbsolutePath(), stagedFile.getName()).execute();
            }
        }
    }

    private static class PrecommittedState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        protected final IStorageProcessorTransactional.IStorageProcessorTransaction transaction;
        protected final File markerFile;
        protected final DataSetStoragePaths storagePaths;

        public PrecommittedState(PreparedState<T> oldState) {
            super(oldState.storageAlgorithm);
            this.transaction = oldState.transaction;
            this.markerFile = oldState.markerFile;
            this.storagePaths = oldState.storagePaths;
        }

        public void commitStorageProcessor() {
            this.transaction.setStoredDataDirectory(this.storagePaths.precommitBaseDirectory);
            this.transaction.commit();
            this.cleanUpMarkerFile();
        }

        public File getStoredDirectory() {
            return this.storagePaths.storeBaseDirectory;
        }

        private void cleanUpMarkerFile() {
            this.getFileOperations().delete(this.markerFile);
            if (this.markerFile.exists()) {
                operationLog.error((Object)("Marker file '" + this.markerFile + "' could not be deleted."));
            }
        }
    }

    private static class PreparedState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        protected final DataSetInformation dataSetInformation;
        protected final IRollbackStack rollbackStack;
        protected final IStorageProcessorTransactional.IStorageProcessorTransaction transaction;
        protected final DataSetStoragePaths storagePaths;
        protected File markerFile;

        public PreparedState(InitializedState<T> oldState) {
            super(oldState.storageAlgorithm);
            this.dataSetInformation = this.storageAlgorithm.getDataSetInformation();
            this.transaction = oldState.transaction;
            this.rollbackStack = oldState.rollbackStack;
            this.storagePaths = oldState.storagePaths;
        }

        public void storeDataInPrecommit() {
            this.markerFile = this.createProcessingMarkerFile();
            this.transactionStoreData();
            this.moveFilesFromStagingToPrecommit();
        }

        private void moveFilesFromStagingToPrecommit() {
            File stagedStoredDataDirectory = this.transaction.getStoredDataDirectory();
            assert (stagedStoredDataDirectory != null) : "The folder that contains the stored data should not be null.";
            File[] stagedFiles = stagedStoredDataDirectory.listFiles();
            if (null == stagedFiles) {
                return;
            }
            for (File stagedFile : stagedFiles) {
                this.rollbackStack.pushAndExecuteCommand(new MoveFileCommand(stagedStoredDataDirectory.getAbsolutePath(), stagedFile.getName(), this.storagePaths.precommitBaseDirectory.getAbsolutePath(), stagedFile.getName()));
            }
        }

        private void transactionStoreData() {
            String entityDescription = this.createEntityDescription();
            if (this.getOperationLog().isInfoEnabled()) {
                this.getOperationLog().info((Object)("Start storing data set for " + entityDescription + "."));
            }
            StopWatch watch = new StopWatch();
            watch.start();
            this.transaction.storeData(this.storageAlgorithm.getRegistrationDetails(), this.getMailClient(), this.incomingDataSetFile);
            if (this.getOperationLog().isInfoEnabled()) {
                this.getOperationLog().info((Object)("Finished storing data set for " + entityDescription + ", took " + watch));
            }
        }

        private IMailClient getMailClient() {
            return this.storageAlgorithm.mailClient;
        }

        private final File createProcessingMarkerFile() {
            File baseDirectory = this.storagePaths.stagingBaseDirectory;
            File baseParentDirectory = baseDirectory.getParentFile();
            String processingDirName = baseDirectory.getName();
            this.markerFile = new File(baseParentDirectory, ".MARKER_processing_" + processingDirName);
            try {
                this.rollbackStack.pushAndExecuteCommand(new NewFileCommand(this.markerFile.getAbsolutePath()));
            }
            catch (IOExceptionUnchecked ex) {
                throw EnvironmentFailureException.fromTemplate((Throwable)ex, (String)"Cannot create marker file '%s'.", (Object[])new Object[]{this.markerFile.getPath()});
            }
            return this.markerFile;
        }

        private String createEntityDescription() {
            SampleIdentifier sampleIdentifier = this.dataSetInformation.getSampleIdentifier();
            if (sampleIdentifier != null) {
                return "sample '" + sampleIdentifier + "'";
            }
            return "experiment '" + this.dataSetInformation.getExperimentIdentifier() + "'";
        }

        private boolean wasStoreDataAttempted() {
            return this.transaction != null;
        }
    }

    private static class InitializedState<T extends DataSetInformation>
    extends DataSetStorageAlgorithmState<T> {
        protected DataSetStoragePaths storagePaths;
        protected IStorageProcessorTransactional.IStorageProcessorTransaction transaction;
        protected IRollbackStack rollbackStack;

        public InitializedState(DataSetStorageAlgorithm<T> storageAlgorithm) {
            super(storageAlgorithm);
        }

        public void prepare(IRollbackStack aStack) {
            this.rollbackStack = aStack;
            IDataStoreStrategy dataStoreStrategy = this.storageAlgorithm.getDataStoreStrategy();
            File stagingBaseDirectory = new File(this.storageAlgorithm.getStagingDirectory(), ((DataSetInformation)this.storageAlgorithm.getDataSetInformation()).getDataSetCode() + "-storage");
            this.rollbackStack.pushAndExecuteCommand(new MkdirsCommand(stagingBaseDirectory.getAbsolutePath()));
            File storeBaseDirectory = DataSetStorageAlgorithm.createBaseDirectory(dataStoreStrategy, this.storageAlgorithm.getStoreRoot(), this.getFileOperations(), this.storageAlgorithm.getDataSetInformation(), this.storageAlgorithm.getDataSetType(), this.incomingDataSetFile, this.rollbackStack);
            IStorageProcessorTransactional.StorageProcessorTransactionParameters transactionParameters = new IStorageProcessorTransactional.StorageProcessorTransactionParameters((DataSetInformation)this.storageAlgorithm.getDataSetInformation(), this.incomingDataSetFile, stagingBaseDirectory);
            this.transaction = this.storageAlgorithm.getStorageProcessor().createTransaction(transactionParameters);
            File precommitBaseDirectory = new File(this.storageAlgorithm.getPreCommitDirectory(), ((DataSetInformation)this.storageAlgorithm.getDataSetInformation()).getDataSetCode() + "-precommit");
            this.storagePaths = new DataSetStoragePaths(stagingBaseDirectory, storeBaseDirectory, precommitBaseDirectory);
        }
    }

    private static abstract class DataSetStorageAlgorithmState<T extends DataSetInformation> {
        protected final DataSetStorageAlgorithm<T> storageAlgorithm;
        protected final File incomingDataSetFile;

        protected DataSetStorageAlgorithmState(DataSetStorageAlgorithm<T> storageAlgorithm) {
            this.storageAlgorithm = storageAlgorithm;
            this.incomingDataSetFile = storageAlgorithm.getIncomingDataSetFile();
        }

        protected Logger getOperationLog() {
            return this.storageAlgorithm.getOperationLog();
        }

        protected IFileOperations getFileOperations() {
            return ((DataSetStorageAlgorithm)this.storageAlgorithm).fileOperations;
        }
    }
}

