/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetOnErrorActionDecision;
import java.util.Properties;

public class ConfiguredOnErrorActionDecision
implements IDataSetOnErrorActionDecision {
    public static final String INVALID_DATA_SET_KEY = "invalid-data-set";
    public static final String OPENBIS_REGISTRATION_FAILURE_KEY = "registration-error";
    public static final String REGISTRATION_SCRIPT_ERROR_KEY = "registration-script-error";
    public static final String VALIDATION_SCRIPT_ERROR_KEY = "validation-script-error";
    public static final String STORAGE_PROCESSOR_ERROR_KEY = "storage-processor-error";
    public static final String PREPARATION_ERROR_KEY = "preparation-error";
    public static final String POST_REGISTRATION_ERROR_KEY = "post-registration-error";
    public static final String PRE_REGISTRATION_ERROR_KEY = "pre-registration-error";
    private final IStorageProcessorTransactional.UnstoreDataAction invalidDataSetAction;
    private final IStorageProcessorTransactional.UnstoreDataAction validationScriptError;
    private final IStorageProcessorTransactional.UnstoreDataAction openbisRegistrationFailure;
    private final IStorageProcessorTransactional.UnstoreDataAction registrationScriptError;
    private final IStorageProcessorTransactional.UnstoreDataAction storageProcessorError;
    private final IStorageProcessorTransactional.UnstoreDataAction postRegistrationError;
    private final IStorageProcessorTransactional.UnstoreDataAction preRegistrationError;
    private final IStorageProcessorTransactional.UnstoreDataAction preparationError;

    public ConfiguredOnErrorActionDecision(Properties properties) {
        this.invalidDataSetAction = this.getAction(IDataSetOnErrorActionDecision.ErrorType.INVALID_DATA_SET, properties);
        this.validationScriptError = this.getAction(IDataSetOnErrorActionDecision.ErrorType.VALIDATION_SCRIPT_ERROR, properties);
        this.openbisRegistrationFailure = this.getAction(IDataSetOnErrorActionDecision.ErrorType.OPENBIS_REGISTRATION_FAILURE, properties);
        this.registrationScriptError = this.getAction(IDataSetOnErrorActionDecision.ErrorType.REGISTRATION_SCRIPT_ERROR, properties);
        this.storageProcessorError = this.getAction(IDataSetOnErrorActionDecision.ErrorType.STORAGE_PROCESSOR_ERROR, properties);
        this.preparationError = this.getAction(IDataSetOnErrorActionDecision.ErrorType.PREPARATION_ERROR, properties);
        this.postRegistrationError = this.getAction(IDataSetOnErrorActionDecision.ErrorType.POST_REGISTRATION_ERROR, properties);
        this.preRegistrationError = this.getAction(IDataSetOnErrorActionDecision.ErrorType.PRE_REGISTRATION_ERROR, properties);
    }

    @Override
    public IStorageProcessorTransactional.UnstoreDataAction computeUndoAction(IDataSetOnErrorActionDecision.ErrorType errorType, Throwable failureOrNull) {
        IStorageProcessorTransactional.UnstoreDataAction action = null;
        switch (errorType) {
            case INVALID_DATA_SET: {
                action = this.invalidDataSetAction;
                break;
            }
            case OPENBIS_REGISTRATION_FAILURE: {
                action = this.openbisRegistrationFailure;
                break;
            }
            case REGISTRATION_SCRIPT_ERROR: {
                action = this.registrationScriptError;
                break;
            }
            case STORAGE_PROCESSOR_ERROR: {
                action = this.storageProcessorError;
                break;
            }
            case PREPARATION_ERROR: {
                action = this.preparationError;
                break;
            }
            case VALIDATION_SCRIPT_ERROR: {
                action = this.validationScriptError;
                break;
            }
            case POST_REGISTRATION_ERROR: {
                action = this.postRegistrationError;
                break;
            }
            case PRE_REGISTRATION_ERROR: {
                action = this.preRegistrationError;
            }
        }
        return action;
    }

    protected IStorageProcessorTransactional.UnstoreDataAction getAction(IDataSetOnErrorActionDecision.ErrorType errorType, Properties properties) {
        IStorageProcessorTransactional.UnstoreDataAction action;
        String actionStringKey = null;
        switch (errorType) {
            case INVALID_DATA_SET: {
                actionStringKey = INVALID_DATA_SET_KEY;
                break;
            }
            case OPENBIS_REGISTRATION_FAILURE: {
                actionStringKey = OPENBIS_REGISTRATION_FAILURE_KEY;
                break;
            }
            case REGISTRATION_SCRIPT_ERROR: {
                actionStringKey = REGISTRATION_SCRIPT_ERROR_KEY;
                break;
            }
            case STORAGE_PROCESSOR_ERROR: {
                actionStringKey = STORAGE_PROCESSOR_ERROR_KEY;
                break;
            }
            case VALIDATION_SCRIPT_ERROR: {
                actionStringKey = VALIDATION_SCRIPT_ERROR_KEY;
                break;
            }
            case POST_REGISTRATION_ERROR: {
                actionStringKey = POST_REGISTRATION_ERROR_KEY;
                break;
            }
            case PRE_REGISTRATION_ERROR: {
                actionStringKey = PRE_REGISTRATION_ERROR_KEY;
                break;
            }
            case PREPARATION_ERROR: {
                actionStringKey = PREPARATION_ERROR_KEY;
            }
        }
        String actionString = PropertyUtils.getProperty((Properties)properties, (String)actionStringKey);
        if (null == actionString) {
            return this.getDefaultAction(errorType);
        }
        actionString = actionString.toUpperCase();
        try {
            action = IStorageProcessorTransactional.UnstoreDataAction.valueOf(actionString);
        }
        catch (IllegalArgumentException ex) {
            action = this.getDefaultAction(errorType);
        }
        return action;
    }

    protected IStorageProcessorTransactional.UnstoreDataAction getDefaultAction(IDataSetOnErrorActionDecision.ErrorType errorType) {
        IStorageProcessorTransactional.UnstoreDataAction action = null;
        switch (errorType) {
            case INVALID_DATA_SET: 
            case OPENBIS_REGISTRATION_FAILURE: 
            case REGISTRATION_SCRIPT_ERROR: 
            case STORAGE_PROCESSOR_ERROR: 
            case PREPARATION_ERROR: 
            case VALIDATION_SCRIPT_ERROR: 
            case POST_REGISTRATION_ERROR: 
            case PRE_REGISTRATION_ERROR: {
                action = IStorageProcessorTransactional.UnstoreDataAction.LEAVE_UNTOUCHED;
            }
        }
        return action;
    }
}

