/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

abstract class AbstractPreOrPostRegistrationExecutor {
    protected final String scriptPath;

    protected static void checkScriptIsAccessible(String script, String adjectivalDescription) {
        File file = new File(script);
        IFileOperations fileOperations = FileOperations.getInstance();
        if (!fileOperations.isFile(file) || !fileOperations.canRead(file)) {
            throw new ConfigurationFailureException(String.format("Cannot access " + adjectivalDescription + " script '%s'.", script));
        }
    }

    protected static boolean callScript(Logger operationLog, Logger machineLog, String scriptPath, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(scriptPath);
        cmd.addAll(Arrays.asList(args));
        boolean result = ProcessExecutionHelper.runAndLog(cmd, (Logger)operationLog, (Logger)machineLog, (long)-1L);
        if (!result) {
            operationLog.warn((Object)String.format("Script execution failed: SCRIPT(%s) PARAMETERS(%s)", scriptPath, StringUtils.join((Object[])args, (String)",")));
        } else {
            operationLog.info((Object)String.format("Successful script execution: SCRIPT(%s) PARAMETERS(%s)", scriptPath, StringUtils.join((Object[])args, (String)",")));
        }
        return result;
    }

    protected AbstractPreOrPostRegistrationExecutor(String script) {
        this.scriptPath = script;
        AbstractPreOrPostRegistrationExecutor.checkScriptIsAccessible(script, this.getExecutorAdjectivalDescription());
    }

    protected abstract String getExecutorAdjectivalDescription();

    protected static class EmptyScriptExecutor {
        protected EmptyScriptExecutor() {
        }

        public boolean execute(String dataSetCode, String path) {
            return true;
        }
    }
}

