/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.utils.Column;
import ch.systemsx.cisd.etlserver.utils.TableBuilder;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public class TabSeparatedValueTable {
    private final RowLineIterator rowLineIterator;
    private final List<String> headers;
    private final boolean strictRowSize;

    public TabSeparatedValueTable(Reader reader, String nameOfReadingSource, boolean ignoreEmptyLines) {
        this(reader, nameOfReadingSource, ignoreEmptyLines, false, false);
    }

    public TabSeparatedValueTable(Reader reader, String nameOfReadingSource, boolean ignoreEmptyLines, boolean strictRowSize, boolean ignoreHashedLines) {
        this.strictRowSize = strictRowSize;
        this.rowLineIterator = new RowLineIterator(IOUtils.lineIterator((Reader)reader), ignoreEmptyLines, ignoreHashedLines);
        if (!this.rowLineIterator.hasNext()) {
            throw new IllegalArgumentException("Empty file '" + nameOfReadingSource + "'.");
        }
        String headerLine = this.rowLineIterator.next();
        if (strictRowSize) {
            int countTrailingTabs = 0;
            for (int i = headerLine.length() - 1; i >= 0 && headerLine.charAt(i) == '\t'; --i) {
                ++countTrailingTabs;
            }
            if (countTrailingTabs > 0) {
                throw new UserFailureException(countTrailingTabs + " trailing tab characters detected in headers line: '" + headerLine + "'.");
            }
        }
        this.headers = this.getRowCells(headerLine);
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<Column> getColumns() {
        TableBuilder builder = new TableBuilder(this.headers);
        while (this.hasMoreRows()) {
            List<String> row = this.tryToGetNextRow();
            builder.addRow(row);
        }
        return builder.getColumns();
    }

    public boolean hasMoreRows() {
        return this.rowLineIterator.hasNext();
    }

    public List<String> tryToGetNextRow() {
        String line = this.rowLineIterator.next();
        if (line == null) {
            return null;
        }
        List<String> row = this.getRowCells(line);
        if (this.strictRowSize && row.size() != this.headers.size()) {
            throw new UserFailureException(this.rowLineIterator.getCurrentLineNumber() - 1 + ". data row has " + row.size() + " instead of " + this.headers.size() + " cells.");
        }
        for (int i = row.size(); i < this.headers.size(); ++i) {
            row.add("");
        }
        return row;
    }

    private List<String> getRowCells(String line) {
        String[] cells = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)line, (String)"\t");
        if (cells == null) {
            cells = new String[]{};
        }
        ArrayList<String> row = new ArrayList<String>();
        row.addAll(Arrays.asList(cells));
        return row;
    }

    private static final class RowLineIterator
    implements Iterator<String> {
        private final LineIterator lineIterator;
        private final boolean ignoreEmptyLines;
        private final boolean ignoreHashedLines;
        private String currentLine;
        private int currentLineNumber;

        RowLineIterator(LineIterator lineIterator, boolean ignoreEmptyLines, boolean ignoreHashedLines) {
            this.lineIterator = lineIterator;
            this.ignoreEmptyLines = ignoreEmptyLines;
            this.ignoreHashedLines = ignoreHashedLines;
        }

        @Override
        public boolean hasNext() {
            if (this.currentLine == null) {
                this.currentLine = this.getNextLine();
            }
            return this.currentLine != null;
        }

        @Override
        public String next() {
            if (this.currentLine == null) {
                this.currentLine = this.getNextLine();
            }
            try {
                String string = this.currentLine;
                return string;
            }
            finally {
                this.currentLine = null;
            }
        }

        public final int getCurrentLineNumber() {
            return this.currentLineNumber;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String getNextLine() {
            String line;
            do {
                if (!this.lineIterator.hasNext()) {
                    return null;
                }
                line = this.lineIterator.nextLine();
                ++this.currentLineNumber;
            } while (this.ignoreEmptyLines && line != null && !StringUtils.isNotBlank((CharSequence)line) || this.ignoreHashedLines && line != null && line.startsWith("#"));
            return line;
        }
    }
}

