/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class Unzipper {
    public static Status unzip(File archiveFile, File outputDirectory, boolean deleteArchive) {
        try {
            ZipFile zipFile = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) {
                    Unzipper.createDirectory(new File(outputDirectory, zipEntry.getName()));
                    continue;
                }
                Unzipper.createFile(outputDirectory, zipFile, zipEntry);
            }
            if (deleteArchive) {
                archiveFile.delete();
            }
        }
        catch (Exception ex) {
            return Status.createError((String)ex.getMessage());
        }
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFile(File outputDir, ZipFile zipFile, ZipEntry zipEntry) throws IOException, FileNotFoundException {
        File outputFile = new File(outputDir, zipEntry.getName());
        File parentDirectory = outputFile.getParentFile();
        if (!parentDirectory.exists()) {
            Unzipper.createDirectory(parentDirectory);
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private static void createDirectory(File directory) {
        boolean directoryCreated = directory.mkdirs();
        if (!directoryCreated) {
            throw EnvironmentFailureException.fromTemplate((String)"Could not create directory '%s'", (Object[])new Object[]{directory});
        }
    }
}

