/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractValidator
implements IValidator {
    private final boolean allowEmptyValues;
    private final Set<String> emptyValueSynonyms;

    AbstractValidator(boolean allowEmptyValues, Set<String> emptyValueSynonyms) {
        this.allowEmptyValues = allowEmptyValues;
        this.emptyValueSynonyms = emptyValueSynonyms;
    }

    @Override
    public final void assertValid(String value) {
        if (this.allowEmptyValues) {
            if (StringUtils.isBlank((CharSequence)value) || this.emptyValueSynonyms.contains(value.trim())) {
                return;
            }
        } else if (StringUtils.isBlank((CharSequence)value)) {
            throw new UserFailureException("Empty value is not allowed.");
        }
        this.assertValidNonEmptyValue(value);
    }

    protected abstract void assertValidNonEmptyValue(String var1);
}

