/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.validation.DefaultValueValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.IColumnHeaderValidator;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.RegExBasedValidator;
import ch.systemsx.cisd.etlserver.validation.Result;
import java.util.Properties;

class ColumnDefinition {
    static final String MANDATORY_KEY = "mandatory";
    static final String ORDER_KEY = "order";
    static final String HEADER_VALIDATOR_KEY = "header-validator";
    static final String HEADER_PATTERN_KEY = "header-pattern";
    static final String VALUE_VALIDATOR_KEY = "value-validator";
    static final String CAN_DEFINE_MULTIPLE_COLUMNS_KEY = "can-define-multiple-columns";
    private final String name;
    private final IColumnHeaderValidator headerValidator;
    private final IValidatorFactory valueValidatorFactory;
    private final boolean mandatory;
    private final Integer orderOrNull;
    private final boolean canDefineMultipleColumns;

    static ColumnDefinition create(String name, Properties properties) {
        IColumnHeaderValidator headerValidator;
        boolean mandatory = PropertyUtils.getBoolean((Properties)properties, (String)MANDATORY_KEY, (boolean)false);
        Integer order = null;
        boolean canDefineMultipleColumns = false;
        if (properties.getProperty(ORDER_KEY) != null) {
            order = PropertyUtils.getInt((Properties)properties, (String)ORDER_KEY, (int)0);
            if (order < 1) {
                throw new ConfigurationFailureException("Order value has to be positive: " + order);
            }
            canDefineMultipleColumns = false;
        } else if (!mandatory) {
            canDefineMultipleColumns = PropertyUtils.getBoolean((Properties)properties, (String)CAN_DEFINE_MULTIPLE_COLUMNS_KEY, (boolean)false);
        }
        String headerValidatorName = properties.getProperty(HEADER_VALIDATOR_KEY);
        if (headerValidatorName == null) {
            String headerPattern = properties.getProperty(HEADER_PATTERN_KEY, ".*");
            headerValidator = new RegExBasedValidator(headerPattern);
        } else {
            ExtendedProperties headerValidatorProperties = ExtendedProperties.getSubset((Properties)properties, (String)"header-validator.", (boolean)true);
            headerValidator = (IColumnHeaderValidator)ClassUtils.create(IColumnHeaderValidator.class, (String)headerValidatorName, (Object[])new Object[]{headerValidatorProperties});
        }
        IValidatorFactory factory = ColumnDefinition.createValidatorFactory(properties);
        return new ColumnDefinition(name, headerValidator, factory, mandatory, order, canDefineMultipleColumns);
    }

    static IValidatorFactory createValidatorFactory(Properties properties) {
        String validatorFactoryName = properties.getProperty(VALUE_VALIDATOR_KEY, DefaultValueValidatorFactory.class.getName());
        IValidatorFactory factory = (IValidatorFactory)ClassUtils.create(IValidatorFactory.class, (String)validatorFactoryName, (Object[])new Object[]{properties});
        return factory;
    }

    private ColumnDefinition(String name, IColumnHeaderValidator headerValidator, IValidatorFactory valueValidatorFactory, boolean mandatory, Integer orderOrNull, boolean canDefineMultipleColumns) {
        this.name = name;
        this.headerValidator = headerValidator;
        this.valueValidatorFactory = valueValidatorFactory;
        this.mandatory = mandatory;
        this.orderOrNull = orderOrNull;
        this.canDefineMultipleColumns = canDefineMultipleColumns;
    }

    boolean canDefineMultipleColumns() {
        return this.canDefineMultipleColumns;
    }

    boolean isMandatory() {
        return this.mandatory;
    }

    Integer getOrderOrNull() {
        return this.orderOrNull;
    }

    String getName() {
        return this.name;
    }

    void assertValidHeader(String header) {
        Result result = this.validateHeader(header);
        if (!result.isValid()) {
            throw new UserFailureException("According to column definition '" + this.name + "' the header '" + header + "' is invalid because of the following reason: " + result);
        }
    }

    Result validateHeader(String header) {
        return this.headerValidator.validateHeader(header);
    }

    IValidator createValidator(String header) {
        return this.valueValidatorFactory.createValidator(header);
    }
}

