/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.etlserver.validation.AnyValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.NumericValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.StringValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.UniqueGroupValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.UniqueValidatorFactory;
import java.util.Properties;

public class DefaultValueValidatorFactory
implements IValidatorFactory {
    static final String VALUE_TYPE_KEY = "value-type";
    private final IValidatorFactory factory;

    public DefaultValueValidatorFactory(Properties properties) {
        String property = properties.getProperty(VALUE_TYPE_KEY, ValueType.ANY.toString());
        ValueType valueType = ValueType.getValueType(property);
        this.factory = valueType.createFactory(properties);
    }

    @Override
    public IValidator createValidator(String header) {
        return this.factory.createValidator(header);
    }

    private static enum ValueType {
        UNIQUE_GROUPS{

            @Override
            public IValidatorFactory createFactory(Properties properties) {
                return new UniqueGroupValidatorFactory(properties);
            }
        }
        ,
        UNIQUE{

            @Override
            public IValidatorFactory createFactory(Properties properties) {
                return new UniqueValidatorFactory(properties);
            }
        }
        ,
        ANY{

            @Override
            public IValidatorFactory createFactory(Properties properties) {
                return AnyValidatorFactory.INSTANCE;
            }
        }
        ,
        STRING{

            @Override
            public IValidatorFactory createFactory(Properties properties) {
                return new StringValidatorFactory(properties);
            }
        }
        ,
        NUMERIC{

            @Override
            public IValidatorFactory createFactory(Properties properties) {
                return new NumericValidatorFactory(properties);
            }
        };


        abstract IValidatorFactory createFactory(Properties var1);

        static ValueType getValueType(String name) {
            ValueType[] values;
            for (ValueType valueType : values = ValueType.values()) {
                if (!valueType.toString().equalsIgnoreCase(name)) continue;
                return valueType;
            }
            throw new ConfigurationFailureException("Invalid value-type: " + name);
        }
    }
}

