/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.validation.ColumnDefinition;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class HeaderBasedValueValidatorFactory
implements IValidatorFactory {
    static final String HEADER_PATTERN_KEY = "header-pattern";
    static final String HEADER_TYPES_KEY = "header-types";
    private final List<HeaderPatternAndFactory> factories = new ArrayList<HeaderPatternAndFactory>();
    private final String headerMessage;

    public HeaderBasedValueValidatorFactory(Properties properties) {
        PropertyParametersUtil.SectionProperties[] columnsProperties = PropertyParametersUtil.extractSectionProperties((Properties)properties, (String)HEADER_TYPES_KEY, (boolean)false);
        StringBuilder builder = new StringBuilder();
        for (PropertyParametersUtil.SectionProperties sectionProperties : columnsProperties) {
            String key = sectionProperties.getKey();
            Properties props = sectionProperties.getProperties();
            String pattern = PropertyUtils.getMandatoryProperty((Properties)props, (String)HEADER_PATTERN_KEY);
            builder.append('\n').append("Regular expression for headers of type '").append(key);
            builder.append("' have to match: ").append(pattern);
            try {
                this.factories.add(new HeaderPatternAndFactory(Pattern.compile(pattern), ColumnDefinition.createValidatorFactory(props)));
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException("Invalid header pattern for header type '" + key + "': " + pattern);
            }
        }
        this.headerMessage = builder.toString();
    }

    @Override
    public IValidator createValidator(String columnHeader) {
        for (HeaderPatternAndFactory factory : this.factories) {
            if (!factory.pattern.matcher(columnHeader).matches()) continue;
            return factory.factory.createValidator(columnHeader);
        }
        throw new UserFailureException("No value validator found for header '" + columnHeader + "': " + this.headerMessage);
    }

    private static final class HeaderPatternAndFactory {
        private final Pattern pattern;
        private final IValidatorFactory factory;

        HeaderPatternAndFactory(Pattern pattern, IValidatorFactory factory) {
            this.pattern = pattern;
            this.factory = factory;
        }
    }
}

