/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.validation.AbstractValidator;
import ch.systemsx.cisd.etlserver.validation.AbstractValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import java.util.Properties;
import java.util.Set;

class NumericValidatorFactory
extends AbstractValidatorFactory {
    static final String VALUE_RANGE_KEY = "value-range";
    private NumericValidator validator;

    NumericValidatorFactory(Properties properties) {
        super(properties);
        String valueRange = properties.getProperty(VALUE_RANGE_KEY);
        Range rangeOrNull = valueRange == null ? null : new Range(valueRange);
        this.validator = new NumericValidator(this.allowEmptyValues, this.emptyValueSynonyms, rangeOrNull);
    }

    @Override
    public IValidator createValidator(String header) {
        return this.validator;
    }

    private static final class NumericValidator
    extends AbstractValidator {
        private final Range rangeOrNull;

        NumericValidator(boolean allowEmptyValues, Set<String> emptyValueSynonyms, Range rangeOrNull) {
            super(allowEmptyValues, emptyValueSynonyms);
            this.rangeOrNull = rangeOrNull;
        }

        @Override
        protected void assertValidNonEmptyValue(String value) {
            try {
                double number = Double.parseDouble(value);
                if (this.rangeOrNull != null) {
                    this.rangeOrNull.assertInRange(number);
                }
            }
            catch (NumberFormatException ex) {
                throw new UserFailureException("Not a number: " + value);
            }
        }
    }

    private static final class Range {
        private double minimum;
        private boolean minimumIncluded;
        private double maximum;
        private boolean maximumIncluded;

        Range(String rangeDescription) {
            if (rangeDescription.length() < 3) {
                throw new ConfigurationFailureException("Invalid range: " + rangeDescription);
            }
            char firstCharacter = rangeDescription.charAt(0);
            if (firstCharacter == '(') {
                this.minimumIncluded = false;
            } else if (firstCharacter == '[') {
                this.minimumIncluded = true;
            } else {
                throw new ConfigurationFailureException("Range has to start with either '(' or '[': " + rangeDescription);
            }
            char lastCharacter = rangeDescription.charAt(rangeDescription.length() - 1);
            if (lastCharacter == ')') {
                this.maximumIncluded = false;
            } else if (lastCharacter == ']') {
                this.maximumIncluded = true;
            } else {
                throw new ConfigurationFailureException("Range has to end with either ')' or ']': " + rangeDescription);
            }
            int indexOfComma = rangeDescription.indexOf(44);
            if (indexOfComma < 0) {
                throw new ConfigurationFailureException("Missing comma in range definition: " + rangeDescription);
            }
            try {
                this.minimum = new Double(rangeDescription.substring(1, indexOfComma));
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationFailureException("Invalid minimum in range definition: " + rangeDescription);
            }
            try {
                this.maximum = new Double(rangeDescription.substring(indexOfComma + 1, rangeDescription.length() - 1));
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationFailureException("Invalid maximum in range definition: " + rangeDescription);
            }
            if (this.maximum < this.minimum) {
                throw new ConfigurationFailureException("Minimum is larger than maximum in range description: " + rangeDescription);
            }
        }

        void assertInRange(double number) {
            if (number < this.minimum || !this.minimumIncluded && number == this.minimum) {
                throw new UserFailureException("Number to small: " + number + (this.minimumIncluded ? " < " : " <= ") + this.minimum);
            }
            if (number > this.maximum || !this.maximumIncluded && number == this.maximum) {
                throw new UserFailureException("Number to large: " + number + (this.maximumIncluded ? " > " : " >= ") + this.maximum);
            }
        }
    }
}

