/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.UniqueGroupValidator;
import java.util.ArrayList;
import java.util.Properties;

class UniqueGroupValidatorFactory
implements IValidatorFactory {
    static final String GROUPS_KEY = "groups";
    private final String regex;
    private final ArrayList<Integer> groups;

    UniqueGroupValidatorFactory(Properties properties) {
        this.regex = PropertyUtils.getMandatoryProperty((Properties)properties, (String)"value-pattern");
        String groupsParameter = PropertyUtils.getMandatoryProperty((Properties)properties, (String)GROUPS_KEY);
        String[] uncheckedGroups = PropertyParametersUtil.parseItemisedProperty((String)groupsParameter, (String)GROUPS_KEY);
        this.groups = new ArrayList();
        for (String g : uncheckedGroups) {
            int value;
            try {
                value = Integer.parseInt(g);
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationFailureException(this.createIllegalGroupMessage(g));
            }
            if (value < 1) {
                throw new ConfigurationFailureException(this.createIllegalGroupMessage(g));
            }
            this.groups.add(value);
        }
    }

    private String createIllegalGroupMessage(String g) {
        return "Illegal group: " + g;
    }

    @Override
    public IValidator createValidator(String header) {
        return new UniqueGroupValidator(this.regex, this.groups);
    }
}

