/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.batch;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.DataSetArchiveVerificationResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.ResultType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class BatchResult {
    SortedMap<String, DataSetArchiveVerificationResult> results = new TreeMap<String, DataSetArchiveVerificationResult>();

    public BatchResult(String ... dataSets) {
        DataSetArchiveVerificationResult missingResult = new DataSetArchiveVerificationResult(VerificationErrorType.ERROR, "Internal error, dataset archive not verified");
        for (String dataSet : dataSets) {
            this.results.put(dataSet, missingResult);
        }
    }

    public int getExitCode() {
        ResultType max = ResultType.OK;
        for (DataSetArchiveVerificationResult result : this.results.values()) {
            if (max.getExitCode() >= result.getType().getExitCode()) continue;
            max = result.getType();
        }
        return max.getExitCode();
    }

    public void add(String dataSet, DataSetArchiveVerificationResult result) {
        this.results.put(dataSet, result);
    }

    public void add(String dataSet, Exception e) {
        this.results.put(dataSet, new DataSetArchiveVerificationResult(e));
    }

    public Collection<String> getDataSets() {
        return this.results.keySet();
    }

    public DataSetArchiveVerificationResult getResult(String dataSet) {
        return (DataSetArchiveVerificationResult)this.results.get(dataSet);
    }
}

