/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.batch;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.BatchResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.DataSetArchiveVerificationResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IDataSetArchiveVerificationBatch;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IDataSetArchiveVerifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;

public class SerialDataSetArchiveVerificationBatch
implements IDataSetArchiveVerificationBatch {
    private final IDataSetArchiveVerifier verifier;
    private final String[] dataSets;
    private BatchResult batchResult;

    public SerialDataSetArchiveVerificationBatch(IDataSetArchiveVerifier verifier, String ... dataSets) {
        this(verifier, new HashSet<DataSetArchiveVerificationResult>(), dataSets);
    }

    public SerialDataSetArchiveVerificationBatch(IDataSetArchiveVerifier verifier, Collection<DataSetArchiveVerificationResult> initialResults, String ... dataSets) {
        this.verifier = verifier;
        this.dataSets = dataSets;
        this.batchResult = new BatchResult(dataSets);
        for (DataSetArchiveVerificationResult initialResult : initialResults) {
            this.batchResult.add(UUID.randomUUID().toString(), initialResult);
        }
    }

    @Override
    public BatchResult run() {
        for (String dataSet : this.dataSets) {
            DataSetArchiveVerificationResult result = this.verifier.run(dataSet);
            try {
                this.batchResult.add(dataSet, result);
            }
            catch (Exception e) {
                this.batchResult.add(dataSet, e);
            }
        }
        return this.batchResult;
    }
}

