/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.cli;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.BatchResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.DataSetArchiveVerificationResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.ResultType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ResultPrinter {
    private final PrintStream out;

    public ResultPrinter(PrintStream out) {
        this.out = out;
    }

    public void print(BatchResult result) {
        Map<ResultType, Integer> counts = this.createCountMap();
        for (String dataSet : result.getDataSets()) {
            DataSetArchiveVerificationResult dataSetResult = result.getResult(dataSet);
            this.printResult(dataSet, dataSetResult);
            ResultType type = dataSetResult.getType();
            counts.put(type, counts.get((Object)type) + 1);
        }
        this.printTotals(counts);
    }

    private void printResult(String dataSet, DataSetArchiveVerificationResult result) {
        List<VerificationError> errors = result.getErrors();
        if (errors.isEmpty()) {
            this.out.println("OK: " + dataSet + " (" + result.getFileName() + ")");
            return;
        }
        for (VerificationError error : errors) {
            VerificationErrorType type = error.getType();
            if (VerificationErrorType.FATAL.equals((Object)type)) {
                this.out.println(result.getErrors().get(0).getMessage());
                continue;
            }
            if (VerificationErrorType.GENERAL_WARNING.equals((Object)type)) {
                this.out.println("WARNING: " + error.getMessage());
                continue;
            }
            this.out.println((Object)((Object)type) + " in " + dataSet + " (" + result.getFileName() + "): " + error.getMessage());
        }
    }

    private Map<ResultType, Integer> createCountMap() {
        EnumMap<ResultType, Integer> counts = new EnumMap<ResultType, Integer>(ResultType.class);
        for (ResultType type : ResultType.values()) {
            counts.put(type, 0);
        }
        return counts;
    }

    private void printTotals(Map<ResultType, Integer> counts) {
        int ok = counts.get((Object)ResultType.OK);
        int warning = counts.get((Object)ResultType.WARNING);
        int error = counts.get((Object)ResultType.ERROR);
        int fatal = counts.get((Object)ResultType.FATAL);
        int generalWarnings = counts.get((Object)ResultType.GENERAL_WARNING);
        int total = ok + warning + error;
        if (fatal > 0) {
            return;
        }
        this.out.println();
        this.out.println("---");
        this.out.println("Total of " + total + " dataset archives tested.");
        if (warning + error == 0) {
            this.out.println("No errors found.");
        } else {
            if (error > 0) {
                this.out.println(error + " archive file(s) contained errors.");
            }
            if (warning > 0) {
                this.out.println(warning + " archive file(s) caused warnings");
            }
        }
        if (generalWarnings > 0) {
            this.out.println(generalWarnings + " general warning(s).");
        }
    }
}

