/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem;

import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.IFileLocator;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetLocationUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.UUID;

public class ShardingFileLocator
implements IFileLocator {
    @Override
    public File getPathToArchiveOfDataSet(File directory, String dataSetCode) {
        for (File uuidDir : directory.listFiles(new UUIDFileFilter())) {
            File candidate = new File(uuidDir, DatasetLocationUtil.getDatasetLocationPath(dataSetCode, "") + "/" + dataSetCode + ".zip");
            if (!candidate.exists()) continue;
            return candidate;
        }
        return new File("...");
    }

    private class UUIDFileFilter
    implements FileFilter {
        private UUIDFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            try {
                UUID.fromString(file.getName());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

