/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.pathinfo;

import ch.systemsx.cisd.openbis.dss.archiveverifier.pathinfo.DataSetPathInfo;
import ch.systemsx.cisd.openbis.dss.archiveverifier.pathinfo.PathInfoEntry;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.IArchiveFileContent;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.IArchiveFileMetaDataRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class JdbcPathInfoRepository
implements IArchiveFileMetaDataRepository {
    private static final String QUERY_PATHINFO = "SELECT dsf.relative_path, dsf.file_name, dsf.size_in_bytes, dsf.checksum_crc32, dsf.is_directory, dsf.last_modified FROM data_sets ds, data_set_files dsf WHERE dsf.dase_id = ds.id AND ds.code=?";
    private final Connection connection;

    public JdbcPathInfoRepository(Connection connection) {
        this.connection = connection;
    }

    @Override
    public IArchiveFileContent getMetaData(String dataSet) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(QUERY_PATHINFO);
            stmt.setString(1, dataSet);
            ResultSet result = stmt.executeQuery();
            HashMap<String, PathInfoEntry> data = new HashMap<String, PathInfoEntry>();
            if (!result.isBeforeFirst()) {
                return null;
            }
            while (result.next()) {
                String file = result.getString("relative_path");
                Integer crc = result.getInt("checksum_crc32");
                if (result.wasNull()) {
                    crc = null;
                }
                Long size = result.getLong("size_in_bytes");
                if (result.wasNull()) {
                    size = null;
                }
                data.put(file, new PathInfoEntry(this.getUnsignedLong(crc), size));
            }
            return new DataSetPathInfo(data);
        }
        catch (SQLException ex) {
            return new IArchiveFileContent(){

                @Override
                public Long getFileCrc(String file) {
                    throw new RuntimeException(ex);
                }

                @Override
                public Long getFileSize(String file) {
                    throw new RuntimeException(ex);
                }
            };
        }
    }

    public Long getUnsignedLong(Integer x) {
        if (x == null) {
            return null;
        }
        return (long)x.intValue() & 0xFFFFFFFFL;
    }

    @Override
    public String getDescription() {
        return "pathinfo db";
    }
}

