/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.verifier;

import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.AbstractZipFileVerifier;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipException;

public class ZipFileIntegrityVerifier
extends AbstractZipFileVerifier {
    @Override
    public List<VerificationError> verify(ZipFile zip) {
        ArrayList<VerificationError> errors = new ArrayList<VerificationError>();
        Enumeration entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            VerificationError error = this.checkZipEntry(zip, entry);
            if (error == null) continue;
            errors.add(error);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerificationError checkZipEntry(ZipFile zip, ZipEntry entry) {
        InputStream input = null;
        try {
            input = zip.getInputStream(entry);
            long crc = this.calculateCRC32(input);
            if (crc != entry.getCrc()) {
                VerificationError verificationError = new VerificationError(VerificationErrorType.ERROR, entry.getName() + ": CRC failure (calculated: " + IOUtilities.crc32ToString((int)((int)crc)) + ", zip file header: " + IOUtilities.crc32ToString((int)((int)entry.getCrc())) + ")");
                return verificationError;
            }
        }
        catch (ZipException ex) {
            VerificationError verificationError = new VerificationError(VerificationErrorType.ERROR, "Corrupted zip file entry, reason: " + ex.getMessage());
            return verificationError;
        }
        catch (IOException ex) {
            VerificationError verificationError = new VerificationError(VerificationErrorType.ERROR, entry.getName() + ": " + ex.getMessage());
            return verificationError;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

