/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class AbstractCommand<T extends GlobalArguments>
implements ICommand {
    protected final T arguments;
    protected final CmdLineParser parser;

    public AbstractCommand(T arguments) {
        this.arguments = arguments;
        this.parser = new CmdLineParser(arguments);
    }

    @Override
    public void printUsage(PrintStream out) {
        out.println(this.getUsagePrefixString() + " [options] " + this.getRequiredArgumentsString());
        this.parser.printUsage((OutputStream)out);
        out.println("  Example : " + this.getCommandCallString() + " " + this.parser.printExample(ExampleMode.ALL) + " " + this.getRequiredArgumentsString());
    }

    public CmdLineParser getParser() {
        return this.parser;
    }

    public T getArguments() {
        return this.arguments;
    }

    protected String getUsagePrefixString() {
        return "usage: " + this.getCommandCallString();
    }

    protected String getCommandCallString() {
        return this.getProgramCallString() + " " + this.getName();
    }

    protected abstract String getProgramCallString();

    protected abstract String getRequiredArgumentsString();
}

