/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandHelp;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommandFactory;

public abstract class AbstractCommandFactory
implements ICommandFactory {
    private ICommandFactory parentCommandFactoryOrNull;

    public ICommand tryHelpCommandForName(String name) {
        if ("-h".equals(name) || "--help".equals(name)) {
            return this.getHelpCommand();
        }
        return null;
    }

    protected ICommandFactory tryParentCommandFactory() {
        return this.parentCommandFactoryOrNull;
    }

    @Override
    public void setParentCommandFactory(ICommandFactory parentCommandFactoryOrNull) {
        this.parentCommandFactoryOrNull = parentCommandFactoryOrNull;
    }

    protected CommandHelp getHelpCommand(String programCallString) {
        ICommandFactory helpFactory = this.tryParentCommandFactory();
        if (null == helpFactory) {
            helpFactory = this;
        }
        return new CommandHelp(helpFactory, programCallString);
    }
}

