/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractExecutor;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandTestValid;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class CommandTestExtractMetadata
extends CommandTestValid {
    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new CommandTestExtractMetadataExecutor((CommandTestValid.CommandTestValidArguments)this.arguments, this).execute(args);
    }

    @Override
    public String getName() {
        return "testextract";
    }

    private static class CommandTestExtractMetadataExecutor
    extends AbstractExecutor<CommandTestValid.CommandTestValidArguments> {
        CommandTestExtractMetadataExecutor(CommandTestValid.CommandTestValidArguments arguments, AbstractDssCommand<CommandTestValid.CommandTestValidArguments> command) {
            super(arguments, command);
        }

        @Override
        protected ResultCode doExecute(IDssComponent component) {
            try {
                Map<String, String> properties;
                NewDataSetDTO newDataSet = this.getNewDataSet();
                if (newDataSet.getFileInfos().isEmpty()) {
                    File file = ((CommandTestValid.CommandTestValidArguments)this.arguments).getFile();
                    if (!file.exists()) {
                        System.err.println("Data set file does not exist");
                    } else if (!file.isDirectory()) {
                        System.err.println("Must select a directory to upload.");
                    } else {
                        System.err.println("Data set is empty.");
                    }
                    return ResultCode.INVALID_ARGS;
                }
                if (null == ((CommandTestValid.CommandTestValidArguments)this.arguments).getScriptPathsOrNull()) {
                    properties = component.extractMetadata(newDataSet, ((CommandTestValid.CommandTestValidArguments)this.arguments).getFile());
                } else {
                    ValidationScriptRunner scriptRunner = ValidationScriptRunner.createValidatorFromScriptPaths(((CommandTestValid.CommandTestValidArguments)this.arguments).getScriptPathsOrNull(), false);
                    properties = scriptRunner.extractMetadata(((CommandTestValid.CommandTestValidArguments)this.arguments).getFile());
                }
                Object[] keys = properties.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                System.out.println("PROPS:");
                for (Object key : keys) {
                    System.out.println("\t" + (String)key + " : " + properties.get(key));
                }
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
            return ResultCode.OK;
        }

        private NewDataSetDTO getNewDataSet() throws IOException {
            NewDataSetDTO.DataSetOwnerType ownerType = ((CommandTestValid.CommandTestValidArguments)this.arguments).getOwnerType();
            String ownerIdentifier = ((CommandTestValid.CommandTestValidArguments)this.arguments).getOwnerIdentifier();
            NewDataSetDTO.DataSetOwner owner = new NewDataSetDTO.DataSetOwner(ownerType, ownerIdentifier);
            File file = ((CommandTestValid.CommandTestValidArguments)this.arguments).getFile();
            ArrayList<FileInfoDssDTO> fileInfos = this.getFileInfosForPath(file);
            String parentNameOrNull = null;
            if (file.isDirectory()) {
                parentNameOrNull = file.getName();
            }
            NewDataSetDTO dataSet = new NewDataSetDTO(owner, parentNameOrNull, fileInfos);
            dataSet.setDataSetTypeOrNull(((CommandTestValid.CommandTestValidArguments)this.arguments).getDataSetType());
            dataSet.setProperties(((CommandTestValid.CommandTestValidArguments)this.arguments).getProperties());
            return dataSet;
        }

        private ArrayList<FileInfoDssDTO> getFileInfosForPath(File file) throws IOException {
            ArrayList<FileInfoDssDTO> fileInfos = new ArrayList<FileInfoDssDTO>();
            if (!file.exists()) {
                return fileInfos;
            }
            String path = file.getCanonicalPath();
            if (!file.isDirectory()) {
                path = file.getParentFile().getCanonicalPath();
            }
            FileInfoDssBuilder builder = new FileInfoDssBuilder(path, path);
            builder.appendFileInfosForFile(file, fileInfos, true);
            return fileInfos;
        }
    }
}

