/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class AbstractEntityPickerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final Timer scheduler = new Timer();
    protected final JFrame mainWindow;
    protected final JButton refreshButton;
    protected final DataSetUploadClientModel clientModel;

    public AbstractEntityPickerDialog(JFrame mainWindow, String title, DataSetUploadClientModel clientModel) {
        super(mainWindow, title, true);
        this.mainWindow = mainWindow;
        this.clientModel = clientModel;
        this.refreshButton = this.createRefreshButton();
    }

    protected abstract void setDialogData();

    protected JButton createRefreshButton() {
        final JButton button = new JButton();
        button.setText("Refresh");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setEnabled(false);
                AbstractEntityPickerDialog.this.refresh();
            }
        });
        return button;
    }

    protected void refresh() {
        new Thread(){

            @Override
            public void run() {
                AbstractEntityPickerDialog.this.clientModel.reloadDataFromServer();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEntityPickerDialog.this.setDialogData();
                        AbstractEntityPickerDialog.this.refreshButton.setEnabled(true);
                    }
                });
            }
        }.start();
    }

    protected static JPanel createFilterAndRefreshButtonPanel(JTextField textField, JButton refreshButton) {
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setMaximumSize(new Dimension(9999, 30));
        refreshButton.setMargin(new Insets(refreshButton.getMargin().top, 2, refreshButton.getMargin().bottom, 2));
        innerPanel.add((Component)textField, "Center");
        innerPanel.add((Component)refreshButton, "East");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        JPanel outerPanel = new JPanel(new GridBagLayout());
        outerPanel.add((Component)innerPanel, gbc);
        return outerPanel;
    }
}

