/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.UiUtilities;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.IAsyncAction;
import java.awt.EventQueue;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class AsyncNodeAction<T>
implements IAsyncAction<T> {
    private final JTree tree;
    private final Timer scheduler;
    private final DefaultMutableTreeNode node;

    public AsyncNodeAction(JTree tree, DefaultMutableTreeNode node, Timer scheduler) {
        this.tree = tree;
        this.node = node;
        this.scheduler = scheduler;
    }

    @Override
    public void performAction(final T data) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AsyncNodeAction.this.handleData(data);
                AsyncNodeAction.this.refreshTreeNode();
            }
        });
    }

    @Override
    public void handleException(Throwable throwable) {
        UiUtilities.showException(this.tree, throwable);
    }

    public abstract void handleData(T var1);

    private void refreshTreeNode() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.nodeStructureChanged(this.node);
        if (this.node.getChildCount() == 0) {
            this.scheduler.schedule(new TimerTask(){

                @Override
                public void run() {
                    AsyncNodeAction.this.tree.collapsePath(new TreePath(AsyncNodeAction.this.node.getPath()));
                }
            }, 1500L);
        }
    }
}

