/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.common.gui.FileChooserUtils;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetPickerPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetPropertiesPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.ErrorsPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.ExperimentPickerPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.SamplePickerPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UiUtilities;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.ValidatedFile;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTOBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataSetMetadataPanel
extends JPanel
implements DataSetPropertiesPanel.Observer {
    private static final String EMPTY_FILE_SELECTION = "";
    private static final long serialVersionUID = 1L;
    private final BlockingQueue<Boolean> validationQueue = new LinkedBlockingQueue<Boolean>();
    private final ModificationDateChecker modificationDateChecker = new ModificationDateChecker();
    private final JFrame mainWindow;
    private final DataSetUploadClientModel clientModel;
    private final JLabel ownerIdLabel;
    private final SamplePickerPanel samplePanel;
    private final DataSetPickerPanel dataSetPanel;
    private final ExperimentPickerPanel experimentPicker;
    private final JPanel ownerIdPanel;
    private final JComboBox ownerComboBox;
    private final JComboBox dataSetTypeComboBox;
    private final JPanel dataSetTypePanel;
    private final JLabel dataSetFileLabel;
    private final JComboBox dataSetFileComboBox;
    private final JButton dataSetFileButton;
    private final JButton dataSetFileValidateButton;
    private final HashMap<String, DataSetPropertiesPanel> propertiesPanels = new HashMap();
    private final ErrorsPanel validationErrors;
    private DataSetUploadClientModel.NewDataSetInfo newDataSetInfo;

    public DataSetMetadataPanel(DataSetUploadClientModel clientModel, JFrame mainWindow) {
        new Thread(new AsynchronousValidator()).start();
        new Thread(this.modificationDateChecker).start();
        this.setLayout(new GridBagLayout());
        this.clientModel = clientModel;
        this.mainWindow = mainWindow;
        this.ownerIdLabel = new JLabel("Owner:", 11);
        this.samplePanel = new SamplePickerPanel(mainWindow, clientModel);
        this.dataSetPanel = new DataSetPickerPanel(mainWindow, clientModel);
        this.experimentPicker = new ExperimentPickerPanel(mainWindow, clientModel);
        this.ownerIdPanel = new JPanel(new CardLayout());
        this.ownerComboBox = new JComboBox<NewDataSetDTO.DataSetOwnerType>(NewDataSetDTO.DataSetOwnerType.values());
        this.ownerIdPanel.add((Component)this.experimentPicker, NewDataSetDTO.DataSetOwnerType.EXPERIMENT.toString());
        this.ownerIdPanel.add((Component)this.samplePanel, NewDataSetDTO.DataSetOwnerType.SAMPLE.toString());
        this.ownerIdPanel.add((Component)this.dataSetPanel, NewDataSetDTO.DataSetOwnerType.DATA_SET.toString());
        this.dataSetTypeComboBox = new JComboBox();
        this.dataSetTypePanel = new JPanel();
        String[] initialOptions = new String[]{EMPTY_FILE_SELECTION};
        this.dataSetFileComboBox = new JComboBox<String>(initialOptions);
        this.dataSetFileButton = new JButton("Browse...");
        this.dataSetFileValidateButton = new JButton("Validate");
        this.dataSetFileLabel = new JLabel("File:", 11);
        this.validationErrors = new ErrorsPanel(mainWindow);
        this.createGui();
    }

    public void setNewDataSetInfo(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo) {
        this.newDataSetInfo = newDataSetInfo;
        this.syncGui();
    }

    private void syncGui() {
        if (null == this.newDataSetInfo) {
            this.dataSetPanel.setText(EMPTY_FILE_SELECTION);
            this.samplePanel.setText(EMPTY_FILE_SELECTION);
            this.experimentPicker.setText(EMPTY_FILE_SELECTION);
            this.updateFileLabel();
            this.disableAllWidgets();
            return;
        }
        this.enableAllWidgets();
        NewDataSetDTOBuilder builder = this.newDataSetInfo.getNewDataSetBuilder();
        NewDataSetDTO.DataSetOwnerType type = builder.getDataSetOwnerType();
        if (type != null) {
            this.ownerComboBox.setSelectedItem((Object)type);
            switch (type) {
                case EXPERIMENT: {
                    this.experimentPicker.setText(builder.getDataSetOwnerIdentifier());
                    break;
                }
                case SAMPLE: {
                    this.samplePanel.setText(builder.getDataSetOwnerIdentifier());
                    break;
                }
                case DATA_SET: {
                    this.dataSetPanel.setText(builder.getDataSetOwnerIdentifier());
                }
            }
        }
        String dataSetTypeOrNull = builder.getDataSetMetadata().tryDataSetType();
        this.dataSetTypeComboBox.setSelectedIndex(this.clientModel.getIndexOfDataSetType(dataSetTypeOrNull));
        if (null != dataSetTypeOrNull) {
            CardLayout cardLayout = (CardLayout)this.dataSetTypePanel.getLayout();
            cardLayout.show(this.dataSetTypePanel, dataSetTypeOrNull);
        }
        for (DataSetPropertiesPanel propertiesPanel : this.propertiesPanels.values()) {
            propertiesPanel.setNewDataSetInfo(this.newDataSetInfo);
        }
        this.updateFileLabel();
        this.syncErrors();
    }

    private void enableAllWidgets() {
        for (JComponent widget : this.getAllEditableWidgets()) {
            widget.setEnabled(true);
        }
    }

    private void disableAllWidgets() {
        for (JComponent widget : this.getAllEditableWidgets()) {
            widget.setEnabled(false);
        }
    }

    private ArrayList<JComponent> getAllEditableWidgets() {
        ArrayList<JComponent> editableWidgets = new ArrayList<JComponent>();
        editableWidgets.add(this.dataSetPanel);
        editableWidgets.add(this.samplePanel);
        editableWidgets.add(this.experimentPicker);
        editableWidgets.add(this.dataSetFileButton);
        editableWidgets.add(this.ownerComboBox);
        editableWidgets.add(this.experimentPicker);
        editableWidgets.add(this.dataSetTypeComboBox);
        for (DataSetPropertiesPanel panel : this.propertiesPanels.values()) {
            editableWidgets.addAll(panel.getAllEditableWidgets());
        }
        return editableWidgets;
    }

    private void createGui() {
        this.dataSetFileLabel.setPreferredSize(new Dimension(110, 30));
        this.dataSetFileComboBox.setPreferredSize(new Dimension(120, 30));
        this.dataSetFileComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (null == DataSetMetadataPanel.this.newDataSetInfo) {
                    return;
                }
                Object selectedItem = e.getItem();
                if (selectedItem != DataSetMetadataPanel.this.newDataSetInfo.getNewDataSetBuilder().getFile()) {
                    if (null == selectedItem || DataSetMetadataPanel.EMPTY_FILE_SELECTION == selectedItem) {
                        DataSetMetadataPanel.this.newDataSetInfo.getNewDataSetBuilder().setFile(null);
                        DataSetMetadataPanel.this.modificationDateChecker.observeFile(null);
                    } else {
                        DataSetMetadataPanel.this.newDataSetInfo.getNewDataSetBuilder().setFile(((ValidatedFile)selectedItem).getFile());
                        DataSetMetadataPanel.this.modificationDateChecker.observeFile((ValidatedFile)selectedItem);
                    }
                    DataSetMetadataPanel.this.validationQueue.add(Boolean.TRUE);
                }
            }
        });
        this.dataSetFileButton.setPreferredSize(new Dimension(90, 30));
        this.dataSetFileButton.setToolTipText("The file to upload.");
        this.dataSetFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == DataSetMetadataPanel.this.newDataSetInfo) {
                    return;
                }
                File newDirOrNull = FileChooserUtils.tryChooseFileOrDirectory((Frame)DataSetMetadataPanel.this.getMainWindow(), (File)DataSetMetadataPanel.this.newDataSetInfo.getNewDataSetBuilder().getFile());
                if (newDirOrNull != null) {
                    DataSetMetadataPanel.this.newDataSetInfo.getNewDataSetBuilder().setFile(newDirOrNull);
                    DataSetMetadataPanel.this.clientModel.userDidSelectFile(new ValidatedFile(newDirOrNull));
                    DataSetMetadataPanel.this.updateFileComboBoxList();
                    DataSetMetadataPanel.this.updateFileLabel();
                    DataSetMetadataPanel.this.validationQueue.add(Boolean.TRUE);
                }
            }
        });
        this.dataSetFileValidateButton.setPreferredSize(new Dimension(90, 30));
        this.dataSetFileValidateButton.setToolTipText("File will be refreshed and revalidated");
        this.dataSetFileValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == DataSetMetadataPanel.this.newDataSetInfo || DataSetMetadataPanel.this.newDataSetInfo.getNewDataSetBuilder().getFile() == null) {
                    return;
                }
                DataSetMetadataPanel.this.validationQueue.add(Boolean.TRUE);
            }
        });
        this.addRow(1, this.dataSetFileLabel, this.dataSetFileComboBox, this.dataSetFileButton, this.dataSetFileValidateButton);
        this.ownerIdLabel.setPreferredSize(new Dimension(110, 30));
        this.samplePanel.setPreferredSize(new Dimension(120, 30));
        this.samplePanel.setToolTipText("Sample identifier");
        this.samplePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.samplePanel.getText());
            }
        });
        this.samplePanel.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.samplePanel.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.experimentPicker.setPreferredSize(new Dimension(120, 30));
        this.experimentPicker.setToolTipText("Experiment identifier");
        this.experimentPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.experimentPicker.getText());
            }
        });
        this.experimentPicker.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.experimentPicker.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.dataSetPanel.setPreferredSize(new Dimension(120, 30));
        this.dataSetPanel.setToolTipText("Parent Data Set code");
        this.dataSetPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.dataSetPanel.getText());
            }
        });
        this.dataSetPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.dataSetPanel.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.ownerComboBox.setPreferredSize(new Dimension(120, 30));
        this.ownerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDataSetDTO.DataSetOwnerType type = (NewDataSetDTO.DataSetOwnerType)((Object)DataSetMetadataPanel.this.ownerComboBox.getSelectedItem());
                if (type != null) {
                    DataSetMetadataPanel.this.setOwnerType(type);
                    DataSetMetadataPanel.this.setOwnerId(DataSetMetadataPanel.this.extractOwnerId(type));
                    CardLayout cardLayout = (CardLayout)DataSetMetadataPanel.this.ownerIdPanel.getLayout();
                    cardLayout.show(DataSetMetadataPanel.this.ownerIdPanel, type.toString());
                }
            }
        });
        this.addRow(2, this.ownerIdLabel, this.ownerIdPanel, this.ownerComboBox);
        JLabel label = new JLabel("Data Set Type:", 11);
        label.setPreferredSize(new Dimension(110, 30));
        this.dataSetTypeComboBox.setPreferredSize(new Dimension(120, 30));
        this.dataSetTypeComboBox.setToolTipText("Select the data set type for the experiment");
        for (DataSetType dataSetType : this.getDataSetTypes()) {
            this.dataSetTypeComboBox.addItem(dataSetType.getCode());
        }
        this.dataSetTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataSetMetadataPanel.this.setDataSetType((String)e.getItem());
                CardLayout cardLayout = (CardLayout)DataSetMetadataPanel.this.dataSetTypePanel.getLayout();
                cardLayout.show(DataSetMetadataPanel.this.dataSetTypePanel, (String)e.getItem());
                DataSetMetadataPanel.this.validationQueue.add(Boolean.TRUE);
            }
        });
        this.addRow(3, label, this.dataSetTypeComboBox);
        this.createDataSetTypePanel();
        this.addRow(4, this.dataSetTypePanel);
        this.addRow(5, this.validationErrors);
    }

    private void setDataSetType(String dataSetType) {
        if (null == this.newDataSetInfo) {
            return;
        }
        this.newDataSetInfo.getNewDataSetBuilder().getDataSetMetadata().setDataSetTypeOrNull(dataSetType);
        this.clientModel.notifyObserversOfChanges(this.newDataSetInfo);
    }

    private void updateFileComboBoxList() {
        this.dataSetFileComboBox.removeAllItems();
        ArrayList<ValidatedFile> files = new ArrayList<ValidatedFile>(this.clientModel.getUserSelectedFiles());
        for (ValidatedFile file : files) {
            this.dataSetFileComboBox.addItem(file);
        }
        this.dataSetFileComboBox.addItem(EMPTY_FILE_SELECTION);
    }

    protected void updateFileLabel() {
        if (null == this.newDataSetInfo) {
            this.dataSetFileComboBox.setSelectedItem(EMPTY_FILE_SELECTION);
            return;
        }
        File file = this.newDataSetInfo.getNewDataSetBuilder().getFile();
        if (null != file) {
            this.dataSetFileComboBox.setSelectedItem(new ValidatedFile(file));
        } else {
            this.dataSetFileComboBox.setSelectedItem(EMPTY_FILE_SELECTION);
        }
    }

    private void createDataSetTypePanel() {
        this.dataSetTypePanel.setLayout(new CardLayout());
        for (DataSetType dataSetType : this.getDataSetTypes()) {
            DataSetPropertiesPanel typeView = new DataSetPropertiesPanel(dataSetType, this.clientModel);
            typeView.registerObserver(this);
            this.dataSetTypePanel.add((Component)typeView, dataSetType.getCode());
            this.propertiesPanels.put(dataSetType.getCode(), typeView);
        }
    }

    private void addRow(int rowy, Component label, Component field, JComboBox comboBox) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = rowy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(label, c);
        c.gridx = 1;
        c.weightx = 0.5;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(field, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 0);
        this.add((Component)comboBox, c);
    }

    private void addRow(int rowy, Component label, Component field, Component button, Component refreshButton) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = rowy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(label, c);
        c.gridx = 1;
        c.weightx = 0.5;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(field, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(button, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 0);
        this.add(refreshButton, c);
    }

    private void addRow(int rowy, Component label, Component field) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = rowy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(label, c);
        c.gridx = 1;
        c.weightx = 0.5;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(field, c);
    }

    private void addRow(int rowy, Component comp) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = rowy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(comp, c);
    }

    private List<DataSetType> getDataSetTypes() {
        return this.clientModel.getDataSetTypes();
    }

    private Frame getMainWindow() {
        return this.mainWindow;
    }

    private void validateAndNotifyObserversOfChanges() {
        this.validationErrors.waitCard();
        this.extractMetadata();
        this.clientModel.validateNewDataSetInfoAndNotifyObservers(this.newDataSetInfo);
        this.syncErrors();
        this.validationErrors.showResult();
    }

    private void extractMetadata() {
        if (this.newDataSetInfo.getNewDataSetBuilder() != null && this.newDataSetInfo.getNewDataSetBuilder().getFile() != null) {
            Map<String, String> properties = this.clientModel.getOpenBISService().extractMetadata(this.newDataSetInfo.getNewDataSetBuilder().asNewDataSetDTO(), this.newDataSetInfo.getNewDataSetBuilder().getFile());
            this.newDataSetInfo.getNewDataSetBuilder().getDataSetMetadata().setUnmodifiableProperties(properties);
        }
        this.syncGui();
    }

    private void setOwnerType(NewDataSetDTO.DataSetOwnerType type) {
        if (null == this.newDataSetInfo) {
            return;
        }
        NewDataSetDTOBuilder builder = this.newDataSetInfo.getNewDataSetBuilder();
        if (builder.getDataSetOwnerType() != type) {
            builder.setDataSetOwnerType(type);
            this.validationQueue.add(Boolean.TRUE);
        }
    }

    private String extractOwnerId(NewDataSetDTO.DataSetOwnerType type) {
        switch (type) {
            case EXPERIMENT: {
                return this.experimentPicker.getText();
            }
            case SAMPLE: {
                return this.samplePanel.getText();
            }
            case DATA_SET: {
                return this.dataSetPanel.getText();
            }
        }
        return null;
    }

    protected void setOwnerId(String text) {
        if (null == this.newDataSetInfo) {
            return;
        }
        NewDataSetDTOBuilder builder = this.newDataSetInfo.getNewDataSetBuilder();
        if (!text.equals(builder.getDataSetOwnerIdentifier())) {
            builder.setDataSetOwnerIdentifier(text);
            this.validationQueue.add(Boolean.TRUE);
        }
    }

    public synchronized void syncErrors() {
        this.clearError(this.ownerIdLabel, this.ownerIdPanel, null);
        this.clearError(this.dataSetFileLabel, this.dataSetFileComboBox, this.validationErrors);
        List<ValidationError> errors = this.newDataSetInfo.getValidationErrors();
        for (ValidationError error : errors) {
            switch (error.getTarget()) {
                case DATA_SET_OWNER: {
                    this.displayError(this.ownerIdLabel, this.ownerIdPanel, this.validationErrors, error);
                    break;
                }
                case DATA_SET_TYPE: {
                    break;
                }
                case DATA_SET_FILE: {
                    this.displayError(this.dataSetFileLabel, this.dataSetFileComboBox, this.validationErrors, error);
                    break;
                }
            }
        }
        for (DataSetPropertiesPanel panel : this.propertiesPanels.values()) {
            panel.syncErrors();
        }
    }

    private void displayError(JLabel label, JComponent component, ErrorsPanel errorAreaOrNull, ValidationError error) {
        if (null == label || null == component) {
            return;
        }
        UiUtilities.displayError(label, component, errorAreaOrNull, error);
    }

    private void clearError(JLabel label, JComponent component, ErrorsPanel errorAreaOrNull) {
        UiUtilities.clearError(label, component, errorAreaOrNull);
        component.setToolTipText(label.getToolTipText());
    }

    @Override
    public void update() {
        this.validationQueue.add(Boolean.TRUE);
    }

    private class ModificationDateChecker
    implements Runnable {
        private ValidatedFile file = null;

        private ModificationDateChecker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (DataSetMetadataPanel.this.isVisible() && this.validationRequired()) {
                            DataSetMetadataPanel.this.validationQueue.add(Boolean.TRUE);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        private synchronized boolean validationRequired() {
            if (this.file != null && this.file.validationRequired()) {
                this.file.markValidation();
                return true;
            }
            return false;
        }

        public synchronized void observeFile(ValidatedFile file) {
            this.file = file;
        }
    }

    private class AsynchronousValidator
    implements Runnable {
        private AsynchronousValidator() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (!((Boolean)DataSetMetadataPanel.this.validationQueue.take()).booleanValue()) {
                            continue;
                        }
                        DataSetMetadataPanel.this.validationQueue.clear();
                        DataSetMetadataPanel.this.validateAndNotifyObserversOfChanges();
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }
}

