/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractTreeEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.AsyncNodeAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UiUtilities;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.IAsyncAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.Identifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.SamplesDataSets;
import ch.systemsx.cisd.openbis.dss.client.api.gui.tree.FilterableMutableTreeNode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class DataSetPickerDialog
extends AbstractTreeEntityPickerDialog {
    private static final long serialVersionUID = 1L;

    public DataSetPickerDialog(JFrame mainWindow, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Pick a data set", NewDataSetDTO.DataSetOwnerType.DATA_SET, clientModel);
        this.setDialogData();
    }

    @Override
    protected void expandNode(final FilterableMutableTreeNode node, Identifier identifier) {
        if (identifier.getOwnerType() != NewDataSetDTO.DataSetOwnerType.DATA_SET) {
            this.clientModel.listSamplesDataSets(identifier, (IAsyncAction<SamplesDataSets>)new AsyncNodeAction<SamplesDataSets>(this.tree, (DefaultMutableTreeNode)node, scheduler){

                @Override
                public void handleData(SamplesDataSets samplesDataSets) {
                    List<DataSet> dataSets = samplesDataSets.getDataSets();
                    node.removeAllChildren();
                    if (dataSets.size() > 0) {
                        FilterableMutableTreeNode dataSetsNode = new FilterableMutableTreeNode("Data Sets");
                        node.add(dataSetsNode, false);
                        for (DataSet dataSet : dataSets) {
                            dataSetsNode.add(new FilterableMutableTreeNode(Identifier.create(dataSet)), false);
                        }
                        dataSetsNode.filter();
                    }
                    for (Sample s : samplesDataSets.getSamples()) {
                        FilterableMutableTreeNode sampleNode = new FilterableMutableTreeNode(Identifier.create(s));
                        sampleNode.add(UiUtilities.createWaitingNode());
                        node.add(sampleNode, false);
                    }
                    node.filter();
                }
            });
        }
    }
}

