/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractTreeEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.AsyncNodeAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UiUtilities;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.IAsyncAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.Identifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.tree.FilterableMutableTreeNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class SamplePickerDialog
extends AbstractTreeEntityPickerDialog {
    private static final long serialVersionUID = 1L;

    public SamplePickerDialog(JFrame mainWindow, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Pick a sample", NewDataSetDTO.DataSetOwnerType.SAMPLE, clientModel);
        this.setDialogData();
    }

    @Override
    protected void expandNode(final FilterableMutableTreeNode node, Identifier identifier) {
        AsyncNodeAction<List<Sample>> action = new AsyncNodeAction<List<Sample>>(this.tree, (DefaultMutableTreeNode)node, scheduler){

            @Override
            public void handleData(List<Sample> samples) {
                node.removeAllChildren();
                for (Sample s : samples) {
                    FilterableMutableTreeNode sampleNode = new FilterableMutableTreeNode(Identifier.create(s));
                    sampleNode.add(UiUtilities.createWaitingNode());
                    node.add(sampleNode, false);
                }
                node.filter();
            }
        };
        this.clientModel.listSamples(identifier, (IAsyncAction<List<Sample>>)action);
    }
}

