/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.ErrorsPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.Identifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.tree.FilterableMutableTreeNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class UiUtilities {
    static final String ROOT_SAMPLES = "Samples";
    static final String ROOT_EXPERIMENTS = "Experiments";
    static final String DATA_SETS = "Data Sets";
    private static final String WAITING_NODE_LABEL = "Loading data ...";
    private static final String[] SPECIAL_NODES = new String[]{"Experiments", "Samples", "Data Sets", "Loading data ..."};

    public static void displayError(JLabel label, JComponent component, ErrorsPanel errorAreaOrNull, ValidationError error) {
        component.setToolTipText(error.getErrorMessage());
        label.setForeground(Color.RED);
        if (errorAreaOrNull != null) {
            errorAreaOrNull.reportError(error);
        }
    }

    public static void clearError(JLabel label, JComponent component, ErrorsPanel errorAreaOrNull) {
        component.setToolTipText(null);
        label.setForeground(Color.BLACK);
        if (errorAreaOrNull != null) {
            errorAreaOrNull.clear();
        }
    }

    public static boolean isMatchingNode(Object node, Pattern pattern) {
        Object userObject;
        for (String specialNode : SPECIAL_NODES) {
            if (!UiUtilities.equals(specialNode, node)) continue;
            return true;
        }
        if (node instanceof FilterableMutableTreeNode && (userObject = ((FilterableMutableTreeNode)node).getUserObject()) instanceof Identifier && ((Identifier)userObject).getOwnerType() == NewDataSetDTO.DataSetOwnerType.DATA_SET) {
            return true;
        }
        return pattern.matcher(node.toString()).find();
    }

    private static boolean equals(String label, Object object) {
        return object.toString().equals(label);
    }

    public static FilterableMutableTreeNode createWaitingNode() {
        return new FilterableMutableTreeNode(WAITING_NODE_LABEL);
    }

    public static void showException(Component parentComponent, Throwable throwable) {
        UiUtilities.showMessageAndException(parentComponent, throwable, throwable.toString(), "Error");
    }

    public static void showMessageAndException(Component parentComponent, final Throwable throwable, String message, String title) {
        final JPanel panel = new JPanel(new BorderLayout(20, 5));
        panel.add((Component)new JLabel(message), "West");
        JButton button = new JButton("Show Details");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.removeAll();
                JTextArea textArea = new JTextArea(20, 20);
                textArea.setEditable(false);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(byteArrayOutputStream, true));
                textArea.setText(byteArrayOutputStream.toString());
                panel.add((Component)textArea, "Center");
                panel.validate();
                SwingUtilities.getWindowAncestor(panel).pack();
            }
        });
        panel.add((Component)button, "East");
        JOptionPane.showMessageDialog(parentComponent, panel, title, 0);
    }
}

