/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.systemsx.cisd.common.api.IRpcService;
import ch.systemsx.cisd.common.api.IRpcServiceFactory;
import ch.systemsx.cisd.common.api.IRpcServiceNameServer;
import ch.systemsx.cisd.common.api.IncompatibleAPIVersionsException;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceDTO;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceVersionDTO;
import ch.systemsx.cisd.common.ssl.SslCertificateHelper;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.ServiceProxyBuilder;
import java.io.File;
import java.util.Collection;

public class DssServiceRpcFactory
implements IRpcServiceFactory {
    private static final long DEFAULT_SERVER_TIMEOUT = 300000L;
    private static final String NAME_SERVER_SUFFIX = "/rmi-name-server";
    private final long timeoutInMillis;

    public DssServiceRpcFactory() {
        this(300000L);
    }

    public DssServiceRpcFactory(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public Collection<RpcServiceInterfaceDTO> getSupportedInterfaces(String serverURL, boolean getServerCertificateFromServer) throws IncompatibleAPIVersionsException {
        String nameServerURL = serverURL + NAME_SERVER_SUFFIX;
        Class<IRpcServiceNameServer> clazz = IRpcServiceNameServer.class;
        if (getServerCertificateFromServer) {
            new SslCertificateHelper(nameServerURL, this.getKeystoreFile(), "dss").setUpKeyStore();
        }
        IRpcServiceNameServer nameServer = (IRpcServiceNameServer)new ServiceProxyBuilder(nameServerURL, clazz, this.timeoutInMillis, 1).getServiceInterface();
        return nameServer.getSupportedInterfaces();
    }

    public <T extends IRpcService> T getService(RpcServiceInterfaceVersionDTO ifaceVersion, Class<T> ifaceClazz, String serverURL, boolean getServerCertificateFromServer) throws IncompatibleAPIVersionsException {
        String serviceURL = serverURL + ifaceVersion.getUrlSuffix();
        if (getServerCertificateFromServer) {
            new SslCertificateHelper(serviceURL, this.getKeystoreFile(), "dss").setUpKeyStore();
        }
        return new ServiceProxyBuilder(serviceURL, ifaceClazz, this.timeoutInMillis, 1).getServiceInterface();
    }

    private File getKeystoreFile() {
        return new File(this.getConfigDirectory(), "keystore");
    }

    private File getConfigDirectory() {
        File configDir;
        String homeDir = System.getProperty("dss.root");
        if (homeDir != null) {
            configDir = new File(homeDir, "etc");
        } else {
            homeDir = System.getProperty("user.home");
            configDir = new File(homeDir, ".dss");
        }
        configDir.mkdirs();
        return configDir;
    }
}

