/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.ApplicationContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDatasetDownloadServlet
extends HttpServlet {
    protected static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, AbstractDatasetDownloadServlet.class);
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractDatasetDownloadServlet.class);
    private static final long serialVersionUID = 1L;
    private static final long IMAGE_CACHE_AGE_IN_SECONDS = 7200L;
    private static final Size DEFAULT_THUMBNAIL_SIZE = new Size(100, 60);
    private static final String THUMBNAIL_MODE_DISPLAY = "thumbnail";
    static final String DISPLAY_MODE_PARAM = "mode";
    static final String DATABASE_INSTANCE_SESSION_KEY = "database-instance";
    static final String DATA_SET_ACCESS_SESSION_KEY = "data-set-access";
    static final String DATA_SET_SESSION_KEY = "data-set";
    protected ApplicationContext applicationContext;

    public AbstractDatasetDownloadServlet() {
    }

    AbstractDatasetDownloadServlet(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            ServletContext context = servletConfig.getServletContext();
            this.applicationContext = (ApplicationContext)context.getAttribute("application-context");
            Enumeration e = servletConfig.getInitParameterNames();
            if (e.hasMoreElements()) {
                this.doSpecificInitialization(e, servletConfig);
            }
        }
        catch (Exception ex) {
            notificationLog.fatal((Object)("Failure during '" + servletConfig.getServletName() + "' servlet initialization."), (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service(request, response);
        }
        finally {
            this.applicationContext.getShareIdManager().releaseLocks();
        }
    }

    protected synchronized void doSpecificInitialization(Enumeration<String> parameterNames, ServletConfig servletConfig) {
    }

    protected final HttpSession tryGetOrCreateSession(HttpServletRequest request, String sessionIdOrNull) {
        HttpSession session = request.getSession(false);
        if (session == null && sessionIdOrNull == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not create a servlet session since no existing servlet session is available, and the openBIS session ID was not provided as a parameter:");
            this.appendRequestParameters(request, sb);
            this.appendServletSessionTimeout(sb);
            operationLog.error((Object)sb.toString());
            return null;
        }
        if (session == null) {
            session = request.getSession(true);
            ConfigParameters configParameters = this.applicationContext.getConfigParameters();
            session.setMaxInactiveInterval(configParameters.getSessionTimeout());
            StringBuilder sb = new StringBuilder();
            sb.append("Creating a new session with the following parameters:");
            this.appendRequestParameters(request, sb);
            this.appendServletSessionTimeout(sb);
            operationLog.info((Object)sb.toString());
        }
        if (sessionIdOrNull != null) {
            session.setAttribute("openbis-session-id", (Object)sessionIdOrNull);
        }
        String sessionToken = session.getAttribute("openbis-session-id").toString();
        if (!this.applicationContext.getSessionTokenCache().isValidSessionToken(sessionToken)) {
            return null;
        }
        return session;
    }

    private void appendServletSessionTimeout(StringBuilder sb) {
        sb.append(" Session Timeout: ");
        sb.append(this.applicationContext.getConfigParameters().getSessionTimeout());
        sb.append(" sec");
    }

    private void appendRequestParameters(HttpServletRequest request, StringBuilder sb) {
        Enumeration e = request.getParameterNames();
        sb.append(" [");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sb.append(name);
            sb.append("=");
            sb.append(request.getParameter(name));
            if (!e.hasMoreElements()) continue;
            sb.append(",");
        }
        sb.append("]");
    }

    protected static final void printSessionExpired(HttpServletResponse response) throws IOException {
        AbstractDatasetDownloadServlet.printErrorResponse(response, "Download session expired.");
    }

    protected static final void printErrorResponse(HttpServletResponse response, String errorMessage) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.write("<html><body>" + errorMessage + "</body></html>");
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeResponseContent(ResponseContentStream responseStream, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Disposition", responseStream.getHeaderContentDisposition());
        if (responseStream.getSize() <= Integer.MAX_VALUE) {
            response.setContentLength((int)responseStream.getSize());
        } else {
            response.addHeader("Content-Length", Long.toString(responseStream.getSize()));
        }
        if ("image/png".equals(responseStream.getContentType())) {
            response.addHeader("Cache-Control", "max-age=7200");
        }
        response.setContentType(responseStream.getContentType());
        ServletOutputStream outputStream = null;
        InputStream content = responseStream.getInputStream();
        try {
            outputStream = response.getOutputStream();
            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    protected static final BufferedImage createThumbnail(IHierarchicalContentNode fileNode, Size thumbnailSize, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        BufferedImage image = ImageUtil.loadImageForDisplay(fileNode, converterOrNull);
        return AbstractDatasetDownloadServlet.createThumbnail(image, thumbnailSize, converterOrNull);
    }

    protected static final BufferedImage createThumbnail(BufferedImage image, Size thumbnailSize, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        int width = thumbnailSize.getWidth();
        int height = thumbnailSize.getHeight();
        return ImageUtil.createThumbnailForDisplay(image, width, height, converterOrNull);
    }

    protected static Size tryAsThumbnailDisplayMode(String displayMode) {
        if (displayMode.startsWith(THUMBNAIL_MODE_DISPLAY)) {
            return AbstractDatasetDownloadServlet.extractSize(displayMode);
        }
        return null;
    }

    private static Size extractSize(String displayMode) {
        String sizeDescription = displayMode.substring(THUMBNAIL_MODE_DISPLAY.length());
        int indexOfSeparator = sizeDescription.indexOf(120);
        if (indexOfSeparator < 0) {
            return DEFAULT_THUMBNAIL_SIZE;
        }
        try {
            int width = Integer.parseInt(sizeDescription.substring(0, indexOfSeparator));
            int height = Integer.parseInt(sizeDescription.substring(indexOfSeparator + 1));
            return new Size(width, height);
        }
        catch (NumberFormatException ex) {
            operationLog.warn((Object)("Invalid numbers in displayMode '" + displayMode + "'. Default thumbnail size is used."));
            return DEFAULT_THUMBNAIL_SIZE;
        }
    }

    protected final File getStoreRootPath() {
        return this.applicationContext.getConfigParameters().getStorePath();
    }

    protected final DatabaseInstance getDatabaseInstance(HttpSession session) {
        DatabaseInstance databaseInstance = (DatabaseInstance)session.getAttribute(DATABASE_INSTANCE_SESSION_KEY);
        if (databaseInstance == null) {
            databaseInstance = this.applicationContext.getDataSetService().getHomeDatabaseInstance();
            session.setAttribute(DATABASE_INSTANCE_SESSION_KEY, (Object)databaseInstance);
        }
        return databaseInstance;
    }

    protected final void ensureDatasetAccessible(String dataSetCode, HttpSession session, String sessionIdOrNull) {
        if (!this.isDatasetAccessible(dataSetCode, sessionIdOrNull, session)) {
            throw new UserFailureException("Data set '" + dataSetCode + "' is not accessible.");
        }
    }

    private boolean isDatasetAccessible(String dataSetCode, String sessionIdOrNull, HttpSession session) {
        Boolean access = this.getDataSetAccess(session).get(dataSetCode);
        if (access == null) {
            if (this.tryToGetCachedDataSet(session, dataSetCode) != null) {
                return true;
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("Check access to the data set '%s' at openBIS server.", dataSetCode));
            }
            IEncapsulatedOpenBISService dataSetService = this.applicationContext.getDataSetService();
            this.ensureSessionIdSpecified(sessionIdOrNull);
            try {
                dataSetService.checkDataSetAccess(sessionIdOrNull, dataSetCode);
                access = true;
            }
            catch (UserFailureException ex) {
                operationLog.error((Object)String.format("Error when checking access to the data set '%s' at openBIS server: %s", dataSetCode, ex.getMessage()));
                return false;
            }
            this.getDataSetAccess(session).put(dataSetCode, access);
        }
        return access;
    }

    private Map<String, Boolean> getDataSetAccess(HttpSession session) {
        HashMap map = (HashMap)session.getAttribute(DATA_SET_ACCESS_SESSION_KEY);
        if (map == null) {
            map = new HashMap();
            session.setAttribute(DATA_SET_ACCESS_SESSION_KEY, map);
        }
        return map;
    }

    protected final AbstractExternalData tryToGetCachedDataSet(HttpSession session, String dataSetCode) {
        return this.getDataSets(session).get(dataSetCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, AbstractExternalData> getDataSets(HttpSession session) {
        Class<AbstractDatasetDownloadServlet> clazz = AbstractDatasetDownloadServlet.class;
        synchronized (AbstractDatasetDownloadServlet.class) {
            HashMap<String, AbstractExternalData> map = (HashMap<String, AbstractExternalData>)session.getAttribute(DATA_SET_SESSION_KEY);
            if (map == null) {
                map = new HashMap<String, AbstractExternalData>();
                session.setAttribute(DATA_SET_SESSION_KEY, map);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map;
        }
    }

    protected final void ensureSessionIdSpecified(String sessionIdOrNull) {
        if (sessionIdOrNull == null) {
            throw new EnvironmentFailureException("Session id not specified in the URL");
        }
    }
}

