/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.spring.AbstractServiceWithLogger;
import ch.systemsx.cisd.openbis.dss.generic.server.IStreamRepository;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.DataStoreApiUrlUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import java.io.File;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDssServiceRpc<T>
extends AbstractServiceWithLogger<T> {
    private final IEncapsulatedOpenBISService openBISService;
    @Autowired
    private final IStreamRepository streamRepository;
    private String downloadUrl;
    private IHierarchicalContentProvider contentProvider;
    private IShareIdManager shareIdManager;
    private File storeDirectory;
    private DatabaseInstance homeDatabaseInstance;

    public final void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = DataStoreApiUrlUtilities.getDataStoreUrlFromDownloadUrl(downloadUrl);
    }

    public void setStoreDirectory(File aFile) {
        this.storeDirectory = aFile;
    }

    protected AbstractDssServiceRpc(IEncapsulatedOpenBISService openBISService, IStreamRepository streamRepository, IShareIdManager shareIdManager, IHierarchicalContentProvider contentProvider) {
        this.openBISService = openBISService;
        this.streamRepository = streamRepository;
        this.shareIdManager = shareIdManager;
        this.contentProvider = contentProvider;
    }

    protected IHierarchicalContentProvider getHierarchicalContentProvider(String sessionToken) {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        OpenBISSessionHolder sessionTokenHolder = new OpenBISSessionHolder();
        sessionTokenHolder.setSessionToken(sessionToken);
        return this.contentProvider.cloneFor((ISessionTokenProvider)sessionTokenHolder);
    }

    protected IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    protected IEncapsulatedOpenBISService getOpenBISService() {
        return this.openBISService;
    }

    protected File getStoreDirectory() {
        return this.storeDirectory;
    }

    protected DatabaseInstance getHomeDatabaseInstance() {
        if (this.homeDatabaseInstance == null) {
            this.homeDatabaseInstance = this.openBISService.getHomeDatabaseInstance();
        }
        return this.homeDatabaseInstance;
    }

    protected IHierarchicalContent getHierarchicalContent(String sessionToken, String dataSetCode) {
        return this.getHierarchicalContentProvider(sessionToken).asContent(dataSetCode);
    }

    protected AbstractExternalData tryGetDataSet(String sessionToken, String dataSetCode) {
        return this.openBISService.tryGetDataSet(sessionToken, dataSetCode);
    }

    protected String addToRepositoryAndReturnDownloadUrl(InputStream stream, String path, long validityDurationInSeconds) {
        return this.downloadUrl + "/" + "stream-content" + "?" + "streamID" + "=" + this.streamRepository.addStream(stream, path, validityDurationInSeconds);
    }
}

