/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.ApplicationContext;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.ITabularDataGraph;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphCollectionConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractTabularDataGraphServlet
extends AbstractDatasetDownloadServlet {
    private static final long serialVersionUID = 1L;
    public static final String DATASET_CODE_PARAM = "dataset";
    public static final String GRAPH_TYPE_CODE = "type";
    protected TabularDataGraphCollectionConfiguration configuration;
    protected static final String PROPERTIES_FILE_KEY = "properties-file";
    public static final String FILE_PATH_PARAM = "file";

    public AbstractTabularDataGraphServlet() {
    }

    public AbstractTabularDataGraphServlet(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected synchronized void doSpecificInitialization(Enumeration<String> parameterNames, ServletConfig servletConfig) {
        if (this.configuration != null) {
            return;
        }
        String propertiesFilePath = servletConfig.getInitParameter(PROPERTIES_FILE_KEY);
        this.configuration = TabularDataGraphCollectionConfiguration.getConfiguration(propertiesFilePath);
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpSession session;
            RequestParams params = new RequestParams(request);
            String sessionId = params.sessionId;
            String datasetCode = params.datasetCode;
            String filePathOrNull = params.filePathOrNull;
            if (datasetCode == null) {
                ExposablePropertyPlaceholderConfigurer config = (ExposablePropertyPlaceholderConfigurer)ServiceProvider.getApplicationContext().getBean("propertyConfigurer");
                String workspace = config.getResolvedProps().getProperty("session-workspace-root-dir");
                if (workspace == null) {
                    workspace = "data/sessionWorkspace";
                }
                File sessionWorkspace = new SessionWorkspaceProvider(new File(workspace), sessionId).getSessionWorkspace();
                filePathOrNull = sessionWorkspace.getAbsolutePath() + "/" + filePathOrNull;
            }
            if ((session = this.tryGetOrCreateSession(request, sessionId)) == null) {
                AbstractTabularDataGraphServlet.printSessionExpired(response);
                return;
            }
            if (datasetCode != null) {
                this.ensureDatasetAccessible(datasetCode, session, sessionId);
            } else if (filePathOrNull == null || !new File(filePathOrNull).exists()) {
                throw new UserFailureException("File '" + filePathOrNull + "' is not accessible.");
            }
            ITabularData fileLines = this.getDatasetLines(request, datasetCode, filePathOrNull);
            ITabularDataGraph generator = this.getConfiguration(request).getGraph(params.graphName, fileLines, (OutputStream)response.getOutputStream());
            response.setContentType("image/png");
            String headerContentDisposition = "inline; filename=plot_" + new Date().getTime();
            response.setHeader("Content-Disposition", headerContentDisposition);
            if (params.height > 0 && params.width > 0) {
                generator.generateImage(params.width, params.height);
            } else {
                generator.generateImage();
            }
        }
        catch (Exception e) {
            operationLog.error((Object)"", (Throwable)e);
            AbstractTabularDataGraphServlet.printErrorResponse(response, "Invalid Request");
        }
    }

    protected TabularDataGraphCollectionConfiguration getConfiguration(HttpServletRequest request) {
        return this.configuration;
    }

    protected abstract ITabularData getDatasetLines(HttpServletRequest var1, String var2, String var3) throws IOException;

    protected static class RequestParams {
        public static final String WIDTH_PARAM = "w";
        public static final String HEIGHT_PARAM = "h";
        private final String sessionId;
        private final String datasetCode;
        private final String filePathOrNull;
        private final String graphName;
        private final int width;
        private final int height;

        public RequestParams(HttpServletRequest request) {
            this.sessionId = RequestParams.getRequiredParameter(request, "sessionID");
            this.datasetCode = RequestParams.getOptionalParameter(request, AbstractTabularDataGraphServlet.DATASET_CODE_PARAM);
            this.filePathOrNull = RequestParams.getOptionalParameter(request, AbstractTabularDataGraphServlet.FILE_PATH_PARAM);
            this.graphName = RequestParams.getOptionalParameter(request, AbstractTabularDataGraphServlet.GRAPH_TYPE_CODE, "dynamic");
            this.width = RequestParams.getIntParam(request, WIDTH_PARAM, 0);
            this.height = RequestParams.getIntParam(request, HEIGHT_PARAM, 0);
        }

        private static int getIntParam(HttpServletRequest request, String paramName, int defaultValue) {
            String value = request.getParameter(paramName);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new UserFailureException("parameter " + paramName + " should be an integer, but is: " + value);
            }
        }

        private static String getOptionalParameter(HttpServletRequest request, String paramName) {
            String value = request.getParameter(paramName);
            return value;
        }

        private static String getOptionalParameter(HttpServletRequest request, String paramName, String defaultValue) {
            String value = request.getParameter(paramName);
            if (null == value) {
                return defaultValue;
            }
            return value;
        }

        private static String getRequiredParameter(HttpServletRequest request, String paramName) {
            String value = request.getParameter(paramName);
            if (value == null) {
                throw new UserFailureException("no value for the parameter " + paramName + " found in the URL");
            }
            return value;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }
}

