/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.IncompatibleAPIVersionsException;
import ch.systemsx.cisd.cifex.rpc.client.RPCServiceFactory;
import ch.systemsx.cisd.common.exceptions.MasqueradingException;
import ch.systemsx.cisd.openbis.dss.generic.server.ICIFEXRPCServiceFactory;

final class CIFEXRPCServiceFactory
implements ICIFEXRPCServiceFactory {
    private static final long serialVersionUID = 1L;
    private final String cifexURL;
    private transient ICIFEXComponent cifexComponent;

    CIFEXRPCServiceFactory(String cifexURL) {
        this.cifexURL = cifexURL;
    }

    @Override
    public ICIFEXComponent createCIFEXComponent() {
        if (this.cifexComponent == null) {
            String serviceURL = this.cifexURL + "/cifex/rpc-service";
            try {
                this.cifexComponent = RPCServiceFactory.createCIFEXComponent((String)serviceURL, (boolean)true);
            }
            catch (IncompatibleAPIVersionsException ex) {
                throw new MasqueradingException((Exception)((Object)ex), "Error occured on DSS");
            }
        }
        return this.cifexComponent;
    }
}

