/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.CommandInfo;
import ch.systemsx.cisd.openbis.dss.generic.server.CommandQueueInfo;
import ch.systemsx.cisd.openbis.dss.generic.server.DeletionCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.ICIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.ProcessDatasetsCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.UploadingCommand;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

class DataSetCommandExecutor
implements IDataSetCommandExecutor {
    private static final String COMMAND_QUEUE_FILE_PREFIX = "commandQueue";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetCommandExecutor.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, DataSetCommandExecutor.class);
    private final File store;
    private final IExtendedBlockingQueue<IDataSetCommand> commandQueue;
    private IShareIdManager shareIdManager;
    private IHierarchicalContentProvider hierarchicalContentProvider;
    private String name;

    public DataSetCommandExecutor(File store, File queueDir, String name) {
        this.store = store;
        this.name = name;
        File queueFile = DataSetCommandExecutor.getCommandQueueFile(queueDir, name);
        this.commandQueue = PersistentExtendedBlockingQueueFactory.createSmartQueue((File)queueFile, (boolean)true);
    }

    void setShareIdManager(IShareIdManager shareIdManager) {
        this.shareIdManager = shareIdManager;
    }

    private static File getCommandQueueFile(File store, String nameOrNull) {
        String fileName = COMMAND_QUEUE_FILE_PREFIX;
        if (StringUtils.isNotBlank((CharSequence)nameOrNull)) {
            fileName = fileName + "-" + nameOrNull;
        }
        return new File(store, fileName);
    }

    @Override
    public void start() {
        String threadName = "Data Set Command Execution";
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            threadName = threadName + " - " + this.name;
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String description = "?";
                try {
                    while (true) {
                        IDataSetCommand command = (IDataSetCommand)DataSetCommandExecutor.this.commandQueue.peekWait();
                        description = command.getDescription();
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info((Object)("Executing " + description));
                        }
                        StopWatch stopWatch = new StopWatch();
                        stopWatch.start();
                        try {
                            IShareIdManager manager = DataSetCommandExecutor.this.getShareIdManager();
                            manager.lock(command.getDataSetCodes());
                            command.execute(DataSetCommandExecutor.this.getHierarchicalContentProvider(), new DataSetDirectoryProvider(DataSetCommandExecutor.this.store, manager));
                        }
                        catch (RuntimeException e) {
                            notificationLog.error((Object)("Error executing command '" + description + "'."), (Throwable)e);
                        }
                        finally {
                            DataSetCommandExecutor.this.getShareIdManager().releaseLocks();
                        }
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info((Object)("Finished executing " + description + " after " + stopWatch));
                        }
                        DataSetCommandExecutor.this.commandQueue.take();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedExceptionUnchecked interruptedExceptionUnchecked) {
                    // empty catch block
                }
                operationLog.info((Object)"Executor stopped");
            }
        }, threadName);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void scheduleDeletionOfDataSets(List<? extends IDatasetLocation> dataSets, int maxNumberOfRetries, long waitingTimeBetweenRetries) {
        this.scheduleCommand(new DeletionCommand(dataSets, maxNumberOfRetries, waitingTimeBetweenRetries));
    }

    @Override
    public void scheduleUploadingDataSetsToCIFEX(ICIFEXRPCServiceFactory cifexServiceFactory, MailClientParameters mailClientParameters, List<AbstractExternalData> dataSets, DataSetUploadContext uploadContext, String cifexAdminUserOrNull, String cifexAdminPasswordOrNull) {
        this.scheduleCommand(new UploadingCommand(cifexServiceFactory, mailClientParameters, dataSets, uploadContext, cifexAdminUserOrNull, cifexAdminPasswordOrNull));
    }

    @Override
    public void scheduleProcessDatasets(IProcessingPluginTask task, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull, String sessionTokenOrNull, DatastoreServiceDescription serviceDescription, MailClientParameters mailClientParameters) {
        this.scheduleCommand(new ProcessDatasetsCommand(task, datasets, parameterBindings, userId, userEmailOrNull, sessionTokenOrNull, serviceDescription, mailClientParameters));
    }

    private void scheduleCommand(IDataSetCommand command) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Scheduling " + command));
        }
        this.commandQueue.add((Object)command);
        operationLog.info((Object)("Scheduled: " + command.getDescription()));
    }

    private IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    @Override
    public Set<String> getDataSetCodesFromCommandQueue() {
        HashSet<String> dataSetCodes = new HashSet<String>();
        for (IDataSetCommand command : this.commandQueue) {
            dataSetCodes.addAll(command.getDataSetCodes());
            operationLog.info((Object)("Gather data set codes from command [" + command.getDescription() + "]"));
        }
        return dataSetCodes;
    }

    public static void listQueuedCommands(File store) {
        List<File> commandQueueFiles = DataSetCommandExecutor.listCommandQueueFiles(store);
        for (File queueFile : commandQueueFiles) {
            PersistentExtendedBlockingQueueDecorator commandQueue;
            if (commandQueueFiles.size() != 1) {
                String fileName = queueFile.getName();
                String queueName = "Default command queue";
                if (fileName.length() > COMMAND_QUEUE_FILE_PREFIX.length()) {
                    queueName = "Command queue '" + fileName.substring(COMMAND_QUEUE_FILE_PREFIX.length() + 1) + "'";
                }
                System.out.println("======= " + queueName + " (" + queueFile + ")");
            }
            if ((commandQueue = PersistentExtendedBlockingQueueFactory.createSmartPersist((File)queueFile)).isEmpty()) {
                System.out.println("Command queue is empty.");
                continue;
            }
            System.out.println("Found " + commandQueue.size() + " items in command queue:");
            for (IDataSetCommand cmd : commandQueue) {
                try {
                    System.out.println(cmd.getDescription());
                }
                catch (RuntimeException ex) {
                    System.err.printf("Error showing description of command '%s':\n", cmd.getClass().getSimpleName());
                    ex.printStackTrace();
                }
            }
        }
    }

    public static List<CommandQueueInfo> getCommandQueueInfos(File store) {
        ArrayList<CommandQueueInfo> result = new ArrayList<CommandQueueInfo>();
        List<File> commandQueueFiles = DataSetCommandExecutor.listCommandQueueFiles(store);
        for (File queueFile : commandQueueFiles) {
            String fileName = queueFile.getName();
            String queueName = "DEFAULT";
            if (fileName.length() > COMMAND_QUEUE_FILE_PREFIX.length()) {
                queueName = fileName.substring(COMMAND_QUEUE_FILE_PREFIX.length() + 1);
            }
            CommandQueueInfo info = new CommandQueueInfo(queueName);
            PersistentExtendedBlockingQueueDecorator commandQueue = PersistentExtendedBlockingQueueFactory.createSmartPersist((File)queueFile);
            for (IDataSetCommand cmd : commandQueue) {
                info.addInfo(new CommandInfo(cmd.getType(), cmd.getDescription(), cmd.getDataSetCodes()));
            }
            result.add(info);
        }
        Collections.sort(result);
        return result;
    }

    private static List<File> listCommandQueueFiles(File store) {
        File[] commandQueueFiles = store.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(DataSetCommandExecutor.COMMAND_QUEUE_FILE_PREFIX);
            }
        });
        return commandQueueFiles == null ? Collections.emptyList() : Arrays.asList(commandQueueFiles);
    }
}

