/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.ethz.sis.openbis.generic.server.dssapi.v3.FileTransferServerServlet;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.upload.StoreShareFileUploadServlet;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceVersionDTO;
import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.config.RetryConfiguration;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.resource.IInitializable;
import ch.systemsx.cisd.common.servlet.InitializeRequestContextHolderFilter;
import ch.systemsx.cisd.common.servlet.MethodFilter;
import ch.systemsx.cisd.openbis.common.api.server.RpcServiceNameServer;
import ch.systemsx.cisd.openbis.dss.generic.server.ApplicationContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.DatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.DatasetImageOverviewServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.DatasetSessionAuthorizer;
import ch.systemsx.cisd.openbis.dss.generic.server.HttpInvokerServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.IdentifiedStreamHandlingServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.OpenbisSessionTokenCache;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionWorkspaceFileDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionWorkspaceFileUploadServlet;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DssSessionAuthorizationHolder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.IDssServiceRpcGenericInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.DataStoreApiUrlUtilities;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.PluginServletConfig;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssCrossOriginFilter;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import com.googlecode.jsonrpc4j.spring.JsonServiceExporter;
import com.marathon.util.spring.StreamSupportingHttpInvokerServiceExporter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.context.WebApplicationContext;

public class DataStoreServer {
    public static final String APPLICATION_CONTEXT_KEY = "application-context";
    private static final String PREFIX = "data-set-download.";
    private static final int PREFIX_LENGTH = "data-set-download.".length();
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataStoreServer.class);
    private static Server server;
    private static final String UPLOAD_GUI_SERVING_SERVLET_PATH = "/dss_upload_gui";
    private static ConfigParameters configParameters;

    public static final void start() {
        assert (server == null) : "Server already started";
        ConfigParameters configParams = DataStoreServer.getConfigParameters();
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        OpenbisSessionTokenCache sessionTokenCache = (OpenbisSessionTokenCache)ServiceProvider.getApplicationContext().getBean("as-session-token-cache");
        ApplicationContext applicationContext = new ApplicationContext(openBISService, sessionTokenCache, ServiceProvider.getShareIdManager(), ServiceProvider.getHierarchicalContentProvider(), configParams);
        DssSessionAuthorizationHolder.setAuthorizer(new DatasetSessionAuthorizer(configParams.getAuthCacheExpirationTimeMins(), configParams.getAuthCacheCleanupTimerPeriodMins()));
        configParams.log();
        server = DataStoreServer.createServer(applicationContext);
        try {
            server.start();
            DataStoreServer.selfTest(applicationContext);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Data set download server ready on port " + applicationContext.getConfigParameters().getPort()));
            }
            ((IInitializable)ServiceProvider.getApplicationContext().getBean("data-store-service")).initialize();
        }
        catch (Exception ex) {
            operationLog.error((Object)"Failed to start server.", (Throwable)ex);
            try {
                ((ConfigurableApplicationContext)ServiceProvider.getApplicationContext()).close();
                server.stop();
            }
            catch (Exception ex1) {
                operationLog.error((Object)"Failed to close application context or to stop jetty server.", (Throwable)ex1);
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex1);
            }
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public static final void stop() {
        assert (server != null) : "Server has not been started.";
        if (server.isRunning()) {
            try {
                server.stop();
            }
            catch (Exception ex) {
                operationLog.error((Object)"Failed to stop server.", (Throwable)ex);
            }
        }
        server = null;
    }

    public static void main(String[] args) {
        LogInitializer.init();
        DataStoreServer.start();
    }

    private static final Server createServer(ApplicationContext applicationContext) {
        ConfigParameters configParams = applicationContext.getConfigParameters();
        int port = configParams.getPort();
        Server thisServer = new Server();
        DataStoreServer.initializeServer(configParams, port, thisServer);
        DataStoreServer.initializeContext(applicationContext, configParams, thisServer);
        return thisServer;
    }

    private static void initializeServer(ConfigParameters configParams, int port, Server thisServer) {
        ServerConnector socketConnector = DataStoreServer.createSocketConnector(configParams, thisServer);
        socketConnector.setPort(port);
        socketConnector.setIdleTimeout(300000L);
        thisServer.addConnector((Connector)socketConnector);
    }

    private static void initializeContext(ApplicationContext applicationContext, ConfigParameters configParams, Server thisServer) {
        ContextHandlerCollection contextHandlers = new ContextHandlerCollection();
        thisServer.setHandler((Handler)contextHandlers);
        DataStoreServer.configureGzipHandler(thisServer);
        DataStoreServer.registerDssUploadClientHandler(thisServer, contextHandlers, configParams);
        ServletContextHandler servletContextHandler = new ServletContextHandler((HandlerContainer)contextHandlers, "/", 1);
        servletContextHandler.setAttribute(APPLICATION_CONTEXT_KEY, (Object)applicationContext);
        servletContextHandler.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ServiceProvider.getApplicationContext());
        servletContextHandler.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        servletContextHandler.getSessionHandler().setSessionIdPathParameterName(null);
        String applicationName = "/datastore_server";
        servletContextHandler.addServlet(new ServletHolder((Servlet)new DataStoreServlet()), "/datastore_server/dss/*");
        DatasetDownloadServlet.setDownloadUrl(configParams.getDownloadURL());
        servletContextHandler.addServlet(DatasetDownloadServlet.class, applicationName + "/*");
        servletContextHandler.addServlet(SessionWorkspaceFileUploadServlet.class, applicationName + "/session_workspace_file_upload");
        servletContextHandler.addServlet(SessionWorkspaceFileDownloadServlet.class, applicationName + "/session_workspace_file_download");
        servletContextHandler.addServlet(StoreShareFileUploadServlet.class, applicationName + "/store_share_file_upload");
        DataStoreServer.initializeRpcServices(servletContextHandler, applicationContext, configParams);
        DataStoreServer.registerPluginServlets(servletContextHandler, configParams.getPluginServlets());
        DataStoreServer.registerImageOverviewServlet(servletContextHandler, configParams);
        DataStoreServer.registerStreamHandlingServlet(servletContextHandler);
    }

    private static void configureGzipHandler(Server thisServer) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(2048);
        gzipHandler.setCheckGzExists(false);
        gzipHandler.setCompressionLevel(-1);
        gzipHandler.setInflateBufferSize(0);
        gzipHandler.setSyncFlush(false);
        gzipHandler.setExcludedAgentPatterns(new String[]{".*MSIE.6\\.0.*"});
        gzipHandler.setExcludedMethodList("");
        gzipHandler.setIncludedMethodList("");
        thisServer.insertHandler((HandlerWrapper)gzipHandler);
    }

    private static void initializeRpcServices(ServletContextHandler context, ApplicationContext applicationContext, ConfigParameters configParams) {
        StreamSupportingHttpInvokerServiceExporter v1ServiceExporter = ServiceProvider.getDssServiceRpcGeneric();
        IDssServiceRpcGenericInternal service = (IDssServiceRpcGenericInternal)v1ServiceExporter.getService();
        service.setStoreDirectory(applicationContext.getConfigParameters().getStorePath());
        String rpcV1Suffix = "/rmi-dss-api-v1";
        String rpcV1Path = DataStoreApiUrlUtilities.getUrlForRpcService(rpcV1Suffix);
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)v1ServiceExporter, rpcV1Path)), rpcV1Path);
        String clientPath = DataStoreApiUrlUtilities.getUrlForRpcService("/service-conversation-client-manager");
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)ServiceProvider.getServiceConversationClientManagerServer(), clientPath)), clientPath);
        String serverPath = DataStoreApiUrlUtilities.getUrlForRpcService("/service-conversation-server-manager");
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)ServiceProvider.getServiceConversationServerManagerServer(), serverPath)), serverPath);
        String jsonRpcV1Suffix = rpcV1Suffix + ".json";
        String jsonRpcV1Path = DataStoreApiUrlUtilities.getUrlForRpcService(jsonRpcV1Suffix);
        JsonServiceExporter jsonV1ServiceExporter = new JsonServiceExporter();
        jsonV1ServiceExporter.setService((Object)service);
        jsonV1ServiceExporter.setServiceInterface(IDssServiceRpcGeneric.class);
        jsonV1ServiceExporter.setObjectMapper(ServiceProvider.getObjectMapperV1());
        jsonV1ServiceExporter.setApplicationContext((org.springframework.context.ApplicationContext)ServiceProvider.getApplicationContext());
        try {
            jsonV1ServiceExporter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot initialize json-rpc service exporter:" + ex.getMessage(), ex);
        }
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)jsonV1ServiceExporter, jsonRpcV1Path)), jsonRpcV1Path);
        String rpcV3Path = DataStoreApiUrlUtilities.getUrlForRpcService("/rmi-data-store-server-v3");
        HttpInvokerServiceExporter v3ServiceExporter = ServiceProvider.getDssServiceV3();
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)v3ServiceExporter, rpcV3Path)), rpcV3Path);
        String jsonRpcV3Path = DataStoreApiUrlUtilities.getUrlForRpcService("/rmi-data-store-server-v3.json");
        JsonServiceExporter jsonV3ServiceExporter = ServiceProvider.getDssServiceJsonV3();
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)jsonV3ServiceExporter, jsonRpcV3Path)), jsonRpcV3Path);
        context.addFilter(DssCrossOriginFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        context.addFilter(InitializeRequestContextHolderFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        context.addFilter(MethodFilter.class, "/*", EnumSet.allOf(DispatcherType.class)).setInitParameter("allowed-methods", "GET, POST");
        HttpInvokerServiceExporter nameServiceExporter = ServiceProvider.getRpcNameServiceExporter();
        String nameServerPath = DataStoreApiUrlUtilities.getUrlForRpcService("/rmi-name-server");
        context.addServlet(new ServletHolder((Servlet)new HttpInvokerServlet((HttpRequestHandler)nameServiceExporter, nameServerPath)), nameServerPath);
        RpcServiceNameServer rpcNameServer = (RpcServiceNameServer)nameServiceExporter.getService();
        RpcServiceInterfaceVersionDTO nameServerVersion = new RpcServiceInterfaceVersionDTO("name-server", "/rmi-name-server", rpcNameServer.getMajorVersion(), rpcNameServer.getMinorVersion());
        RpcServiceInterfaceVersionDTO v1Interface = new RpcServiceInterfaceVersionDTO("DSS Service", rpcV1Suffix, service.getMajorVersion(), service.getMinorVersion());
        RpcServiceInterfaceVersionDTO jsonV1Interface = new RpcServiceInterfaceVersionDTO("DSS Service", jsonRpcV1Suffix, service.getMajorVersion(), service.getMinorVersion());
        rpcNameServer.addSupportedInterfaceVersion(nameServerVersion);
        rpcNameServer.addSupportedInterfaceVersion(v1Interface);
        rpcNameServer.addSupportedInterfaceVersion(jsonV1Interface);
    }

    private static void registerPluginServlets(ServletContextHandler context, List<PluginServletConfig> pluginServlets) {
        for (PluginServletConfig pluginServlet : pluginServlets) {
            Class<?> classInstance;
            try {
                classInstance = Class.forName(pluginServlet.getServletClass());
            }
            catch (ClassNotFoundException ex) {
                throw EnvironmentFailureException.fromTemplate((String)"Error while loading servlet plugin class '%s': %s", (Object[])new Object[]{pluginServlet.getClass(), ex.getMessage()});
            }
            catch (ClassCastException ex) {
                throw EnvironmentFailureException.fromTemplate((String)"Error while loading servlet plugin class '%s': %s. Servlet implementation expected.", (Object[])new Object[]{pluginServlet.getClass(), ex.getMessage()});
            }
            ServletHolder holder = context.addServlet(classInstance, pluginServlet.getServletPath());
            holder.setInitParameters(pluginServlet.getServletProperties());
        }
    }

    private static void registerImageOverviewServlet(ServletContextHandler context, ConfigParameters configParams) {
        DatasetImageOverviewServlet.initConfiguration(configParams.getProperties());
        context.addServlet(DatasetImageOverviewServlet.class, "/image-overview/*");
    }

    private static void registerStreamHandlingServlet(ServletContextHandler context) {
        context.addServlet(IdentifiedStreamHandlingServlet.class, "/datastore_server/stream-content/*");
        context.addServlet(FileTransferServerServlet.class, "/datastore_server/file-transfer/*");
    }

    private static void registerDssUploadClientHandler(Server thisServer, ContextHandlerCollection context, ConfigParameters configParams) {
        String servletPathSuffix = UPLOAD_GUI_SERVING_SERVLET_PATH;
        String servletPath = DataStoreApiUrlUtilities.getUrlForRpcService(servletPathSuffix);
        ContextHandler webstartContextHandler = new ContextHandler((HandlerContainer)context, servletPath);
        webstartContextHandler.setResourceBase(configParams.getWebstartJarPath() + servletPathSuffix);
        ResourceHandler webstartJarHandler = new ResourceHandler();
        webstartContextHandler.setHandler((Handler)webstartJarHandler);
    }

    private static ServerConnector createSocketConnector(ConfigParameters configParams, Server thisServer) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        if (configParams.isUseSSL()) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(configParams.getKeystorePath());
            sslContextFactory.setKeyStorePassword(configParams.getKeystorePassword());
            sslContextFactory.setKeyManagerPassword(configParams.getKeystoreKeyPassword());
            String[] excludedProtocols = new String[]{"SSL", "SSLv2", "SSLv2Hello", "SSLv3"};
            sslContextFactory.setExcludeProtocols(excludedProtocols);
            String[] excludedCiphers = new String[]{"TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256"};
            sslContextFactory.setExcludeCipherSuites(excludedCiphers);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            return new ServerConnector(thisServer, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfig)});
        }
        operationLog.warn((Object)"creating connector to openBIS without SSL");
        return new ServerConnector(thisServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
    }

    private static final void selfTest(ApplicationContext applicationContext) {
        new RetryingSelfTest(applicationContext).callWithRetry();
    }

    public static ConfigParameters getConfigParameters() {
        if (configParameters == null) {
            ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
            Properties systemProperties = System.getProperties();
            Enumeration<?> propertyNames = systemProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (!name.startsWith(PREFIX)) continue;
                String value = systemProperties.getProperty(name);
                properties.setProperty(name.substring(PREFIX_LENGTH), value);
            }
            configParameters = new ConfigParameters((Properties)ExtendedProperties.createWith((Properties)properties));
        }
        return configParameters;
    }

    public static String getConfigParameter(String key, String defaultValue) {
        return DataStoreServer.getConfigParameters().getProperties().getProperty(key, defaultValue);
    }

    private static class RetryingSelfTest
    extends RetryCaller<Void, RuntimeException> {
        private final ApplicationContext applicationContext;

        RetryingSelfTest(ApplicationContext applicationContext) {
            super(new RetryConfiguration(){

                public float getWaitingTimeBetweenRetriesIncreasingFactor() {
                    return 2.0f;
                }

                public int getWaitingTimeBetweenRetries() {
                    return 5000;
                }

                public int getMaximumNumberOfRetries() {
                    return 5;
                }
            }, (ISimpleLogger)new Log4jSimpleLogger(operationLog));
            this.applicationContext = applicationContext;
        }

        protected boolean isRetryableException(RuntimeException e) {
            return true;
        }

        protected Void call() throws RuntimeException {
            IEncapsulatedOpenBISService dataSetService = this.applicationContext.getDataSetService();
            int version = dataSetService.getVersion();
            if (35 != version) {
                throw new ConfigurationFailureException("This client has the wrong service version for the server (client: 35, server: " + version + ").");
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("openBIS service (interface version " + version + ") is reachable"));
            }
            return null;
        }
    }

    private static final class DataStoreServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private HttpRequestHandler target;

        private DataStoreServlet() {
        }

        public void init() throws ServletException {
            this.target = ServiceProvider.getDataStoreServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            LocaleContextHolder.setLocale((Locale)request.getLocale());
            try {
                this.target.handleRequest(request, response);
            }
            catch (HttpRequestMethodNotSupportedException ex) {
                Object[] supportedMethods = ex.getSupportedMethods();
                if (supportedMethods != null) {
                    response.setHeader("Allow", StringUtils.arrayToDelimitedString((Object[])supportedMethods, (String)", "));
                }
                response.sendError(405, ex.getMessage());
            }
            finally {
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }
}

