/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidAuthenticationException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.common.spring.AbstractServiceWithLogger;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.dss.generic.server.CIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServiceLogger;
import ch.systemsx.cisd.openbis.dss.generic.server.ICIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutorProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.OpenbisSessionTokenCache;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionTokenManager;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.UploadingCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.ArchiverPluginFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.PluginTaskProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDeleter;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.ISessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchDomainService;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.UuidUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class DataStoreService
extends AbstractServiceWithLogger<IDataStoreService>
implements IDataStoreServiceInternal,
InitializingBean {
    private static final String COPYING_TO_ARCHIVE_PROCESSING_PLUGIN_KEY = "Copying data sets to archive";
    private static final String ARCHIVING_PROCESSING_PLUGIN_KEY = "Archiving";
    private static final String UNARCHIVING_PROCESSING_PLUGIN_KEY = "Unarchiving";
    private final SessionTokenManager sessionTokenManager;
    private final OpenbisSessionTokenCache sessionTokenCache;
    private final IDataSetCommandExecutorProvider dataSetCommandExecutorProvider;
    private final MailClientParameters mailClientParameters;
    private final IPluginTaskInfoProvider pluginTaskInfoProvider;
    private IHierarchicalContentProvider hierarchicalContentProvider;
    private IShareIdManager shareIdManager;
    private String cifexAdminUserOrNull;
    private String cifexAdminPasswordOrNull;
    private File storeRoot;
    private PutDataSetService putService;
    private IConfigProvider config;
    private final Map<String, List<IDelegatedAction>> cleanupActions = new HashMap<String, List<IDelegatedAction>>();

    public DataStoreService(SessionTokenManager sessionTokenManager, OpenbisSessionTokenCache sessionTokenCache, MailClientParameters mailClientParameters, IPluginTaskInfoProvider pluginTaskParameters, IDataSetCommandExecutorProvider dataSetCommandExecutorProvider) {
        this.sessionTokenManager = sessionTokenManager;
        this.sessionTokenCache = sessionTokenCache;
        this.mailClientParameters = mailClientParameters;
        this.pluginTaskInfoProvider = pluginTaskParameters;
        this.dataSetCommandExecutorProvider = dataSetCommandExecutorProvider;
        this.storeRoot = pluginTaskParameters.getStoreRoot();
    }

    void setShareIdManager(IShareIdManager shareIdManager) {
        this.shareIdManager = shareIdManager;
    }

    public void setCifexAdminUserOrNull(String cifexAdminUserOrNull) {
        this.cifexAdminUserOrNull = cifexAdminUserOrNull;
    }

    public void setCifexAdminPasswordOrNull(String cifexAdminPasswordOrNull) {
        this.cifexAdminPasswordOrNull = cifexAdminPasswordOrNull;
    }

    public void afterPropertiesSet() {
        String prefix = "Property 'storeRoot' ";
        if (this.storeRoot == null) {
            throw new IllegalStateException(prefix + "not set.");
        }
        String storeRootPath = this.storeRoot.getAbsolutePath();
        if (this.storeRoot.isFile()) {
            throw new IllegalArgumentException(prefix + "is a file instead of a directory: " + storeRootPath);
        }
        if (!this.storeRoot.exists()) {
            if (!this.storeRoot.mkdirs()) {
                throw new IOExceptionUnchecked(new IOException("Couldn't create root directory of the data store: " + storeRootPath));
            }
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)("Creates root directory of the data store: " + storeRootPath));
            }
        }
        this.migrateStore();
        ArchiverPluginFactory factory = this.pluginTaskInfoProvider.getArchiverPluginFactory();
        if (factory.isArchiverConfigured()) {
            factory.createInstance(this.storeRoot);
        }
    }

    public void initialize() {
        this.dataSetCommandExecutorProvider.init(this.storeRoot);
        this.getShareIdManager().isKnown("");
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info((Object)"Initialization finished.");
        }
    }

    private void migrateStore() {
        File defaultShare = new File(this.storeRoot, "1");
        if (!defaultShare.exists()) {
            File[] stores;
            if (!defaultShare.mkdirs()) {
                throw new IOExceptionUnchecked(new IOException("Couldn't create default share in data store: " + defaultShare));
            }
            for (File file : stores = this.storeRoot.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return UuidUtil.isValidUUID((String)name);
                }
            })) {
                if (file.renameTo(new File(defaultShare, file.getName()))) continue;
                throw new IOExceptionUnchecked(new IOException("Couldn't move '" + file + "' into default share '" + defaultShare + "'."));
            }
            this.operationLog.info((Object)"Store migrated to default share");
        }
    }

    public IDataStoreService createLogger(IInvocationLoggerContext context) {
        return new DataStoreServiceLogger(this.operationLog, context);
    }

    public int getVersion(String sessionToken) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKnownDataSets(String sessionToken, List<? extends IDatasetLocation> dataSets, boolean ignoreNonExistingLocation) throws InvalidAuthenticationException {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        IServiceConversationProgressListener listener = ServiceConversationsThreadContext.getProgressListener();
        ArrayList<String> knownLocations = new ArrayList<String>();
        IShareIdManager manager = this.getShareIdManager();
        int index = 0;
        for (IDatasetLocation iDatasetLocation : dataSets) {
            String datasetCode = iDatasetLocation.getDataSetCode();
            String location = iDatasetLocation.getDataSetLocation();
            manager.lock(datasetCode);
            try {
                if (manager.isKnown(datasetCode) && (ignoreNonExistingLocation || new File(new File(this.storeRoot, manager.getShareId(datasetCode)), location).exists())) {
                    knownLocations.add(location);
                }
            }
            finally {
                manager.releaseLock(datasetCode);
            }
            listener.update("getKnownDataSets", dataSets.size(), ++index);
        }
        return knownLocations;
    }

    public void uploadDataSetsToCIFEX(String sessionToken, List<AbstractExternalData> dataSets, DataSetUploadContext context) throws InvalidAuthenticationException {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        if (context.getCifexURL() == null) {
            throw new ConfigurationFailureException("Upload of data sets to CIFEX not possible: no CIFEX URL configured.");
        }
        ICIFEXRPCServiceFactory serviceFactory = this.createCIFEXRPCServiceFactory(context.getCifexURL());
        ICIFEXComponent cifex = serviceFactory.createCIFEXComponent();
        String userID = context.getUserID();
        String password = context.getPassword();
        if (!UploadingCommand.canLoginToCIFEX(cifex, context.isUserAuthenticated(), userID, password, this.cifexAdminUserOrNull, this.cifexAdminPasswordOrNull)) {
            throw new InvalidSessionException("User failed to be authenticated by CIFEX.");
        }
        IDataSetCommandExecutor commandExecutor = this.dataSetCommandExecutorProvider.getDefaultExecutor();
        commandExecutor.scheduleUploadingDataSetsToCIFEX(serviceFactory, this.mailClientParameters, dataSets, context, this.cifexAdminUserOrNull, this.cifexAdminPasswordOrNull);
    }

    protected ICIFEXRPCServiceFactory createCIFEXRPCServiceFactory(String cifexURL) {
        return new CIFEXRPCServiceFactory(cifexURL);
    }

    public TableModel createReportFromDatasets(String sessionToken, String userSessionToken, String serviceKey, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return this.internalCreateReportFromDatasets(userSessionToken, serviceKey, datasets, userId, userEmailOrNull);
    }

    public void processDatasets(String sessionToken, String userSessionToken, String serviceKey, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        PluginTaskProvider<IProcessingPluginTask> plugins = this.pluginTaskInfoProvider.getProcessingPluginsProvider();
        IProcessingPluginTask task = plugins.getPluginInstance(serviceKey);
        DatastoreServiceDescription pluginDescription = plugins.getPluginDescription(serviceKey);
        this.scheduleTask(userSessionToken, serviceKey, task, datasets, userId, userEmailOrNull, pluginDescription, parameterBindings);
    }

    public void unarchiveDatasets(String sessionToken, String userSessionToken, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        UnarchiveProcessingPluginTask task = new UnarchiveProcessingPluginTask(this.getArchiverPlugin());
        this.scheduleTask(sessionToken, userSessionToken, UNARCHIVING_PROCESSING_PLUGIN_KEY, task, datasets, userId, userEmailOrNull, new HashMap<String, String>());
    }

    public boolean isArchivingPossible(String sessionToken) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return this.getArchiverPlugin().isArchivingPossible();
    }

    public List<String> getDataSetCodesForUnarchiving(String sessionToken, String userSessionToken, List<String> datasets, String userId) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return this.getArchiverPlugin().getDataSetCodesForUnarchiving(datasets);
    }

    public void archiveDatasets(String sessionToken, String userSessionToken, List<DatasetDescription> datasets, String userId, String userEmailOrNull, boolean removeFromDataStore, Map<String, String> options) {
        String description = removeFromDataStore ? ARCHIVING_PROCESSING_PLUGIN_KEY : COPYING_TO_ARCHIVE_PROCESSING_PLUGIN_KEY;
        ArchiveProcessingPluginTask task = new ArchiveProcessingPluginTask(this.getArchiverPlugin(), removeFromDataStore);
        System.err.println("archive " + datasets + " options:" + options);
        this.scheduleTask(sessionToken, userSessionToken, description, task, datasets, userId, userEmailOrNull, options);
    }

    @Override
    public IArchiverPlugin getArchiverPlugin() {
        ArchiverPluginFactory factory = this.pluginTaskInfoProvider.getArchiverPluginFactory();
        return factory.createInstance(this.storeRoot);
    }

    @Override
    public IDataSetDirectoryProvider getDataSetDirectoryProvider() {
        return new DataSetDirectoryProvider(this.storeRoot, this.getShareIdManager());
    }

    @Override
    public ISessionWorkspaceProvider getSessionWorkspaceProvider(String userSessionToken) {
        return new SessionWorkspaceProvider(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken);
    }

    public TableModel createReportFromAggregationService(String sessionToken, String userSessionToken, String serviceKey, Map<String, Object> parameters, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return this.internalCreateReportFromAggregationService(userSessionToken, serviceKey, parameters, userId, userEmailOrNull);
    }

    @Override
    public IMailClient createEMailClient() {
        return new MailClient(this.mailClientParameters);
    }

    private void scheduleTask(String sessionToken, String userSessionToken, String description, IProcessingPluginTask processingTask, List<DatasetDescription> datasets, String userId, String userEmailOrNull, Map<String, String> options) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        DatastoreServiceDescription pluginDescription = DatastoreServiceDescription.processing((String)description, (String)description, null, null);
        this.scheduleTask(userSessionToken, description, processingTask, datasets, userId, userEmailOrNull, pluginDescription, options);
    }

    @Override
    public void scheduleTask(String taskKey, IProcessingPluginTask task, Map<String, String> parameterBindings, List<DatasetDescription> datasets, String userId, String userEmailOrNull, String userSessionToken) {
        DatastoreServiceDescription description = DatastoreServiceDescription.processing((String)taskKey, (String)taskKey, null, null);
        this.scheduleTask(userSessionToken, taskKey, task, datasets, userId, userEmailOrNull, description, parameterBindings);
    }

    private void scheduleTask(String userSessionToken, String taskKey, IProcessingPluginTask processingTask, List<DatasetDescription> datasets, String userId, String userEmailOrNull, DatastoreServiceDescription pluginDescription, Map<String, String> parameterBindings) {
        IDataSetCommandExecutor commandExecutor = this.dataSetCommandExecutorProvider.getExecutor(processingTask, taskKey);
        commandExecutor.scheduleProcessDatasets(processingTask, datasets, parameterBindings, userId, userEmailOrNull, userSessionToken, pluginDescription, this.mailClientParameters);
    }

    private static ArchiverTaskContext createContext(DataSetProcessingContext context) {
        ArchiverTaskContext archiverTaskContext = new ArchiverTaskContext(context.getDirectoryProvider(), context.getHierarchicalContentProviderUnfiltered());
        archiverTaskContext.setUserId(context.getUserId());
        archiverTaskContext.setUserEmail(context.getUserEmailOrNull());
        archiverTaskContext.setUserSessionToken(context.trySessionToken());
        archiverTaskContext.setOptions(context.getParameterBindings());
        return archiverTaskContext;
    }

    public LinkModel retrieveLinkFromDataSet(String sessionToken, String serviceKey, DatasetDescription dataSet) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        PluginTaskProvider<IReportingPluginTask> reportingPlugins = this.pluginTaskInfoProvider.getReportingPluginsProvider();
        IReportingPluginTask task = reportingPlugins.getPluginInstance(serviceKey);
        return task.createLink(dataSet);
    }

    @Override
    public IDataSetDeleter getDataSetDeleter() {
        return this.dataSetCommandExecutorProvider.getDefaultExecutor();
    }

    public String putDataSet(String sessionToken, String dropboxName, CustomImportFile customImportFile) {
        PutDataSetService service = this.getPutDataSetService();
        return service.putDataSet(sessionToken, dropboxName, customImportFile);
    }

    public void cleanupSession(String userSessionToken) {
        List<IDelegatedAction> actions;
        this.sessionTokenCache.removeSessionToken(userSessionToken);
        File sessionWorkspace = new File(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken);
        if (sessionWorkspace.exists()) {
            QueueingPathRemoverService.removeRecursively((File)sessionWorkspace);
        }
        if ((actions = this.cleanupActions.remove(userSessionToken)) != null) {
            for (IDelegatedAction action : actions) {
                action.execute();
            }
        }
        this.getPutDataSetService().cleanupSession(userSessionToken);
    }

    @Override
    public void addCleanupAction(String userSessionToken, IDelegatedAction action) {
        List<IDelegatedAction> actions = this.cleanupActions.get(userSessionToken);
        if (actions == null) {
            actions = new ArrayList<IDelegatedAction>();
            this.cleanupActions.put(userSessionToken, actions);
        }
        actions.add(action);
    }

    public List<SearchDomain> listAvailableSearchDomains(String sessionToken) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        PluginTaskProvider<ISearchDomainService> provider = this.pluginTaskInfoProvider.getSearchDomainServiceProvider();
        List<DatastoreServiceDescription> pluginDescriptions = provider.getPluginDescriptions();
        ArrayList<SearchDomain> result = new ArrayList<SearchDomain>();
        for (DatastoreServiceDescription description : pluginDescriptions) {
            String name = description.getKey();
            ISearchDomainService service = provider.getPluginInstance(name);
            if (!service.isAvailable()) continue;
            SearchDomain searchDomain = new SearchDomain();
            searchDomain.setDataStoreCode(this.config.getDataStoreCode());
            searchDomain.setName(name);
            searchDomain.setLabel(description.getLabel());
            searchDomain.setPossibleSearchOptionsKey(service.getPossibleSearchOptionsKey());
            searchDomain.setPossibleSearchOptions(service.getPossibleSearchOptions());
            result.add(searchDomain);
        }
        return result;
    }

    public List<SearchDomainSearchResult> searchForEntitiesWithSequences(String sessionToken, String preferredSearchDomainOrNull, String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        PluginTaskProvider<ISearchDomainService> provider = this.pluginTaskInfoProvider.getSearchDomainServiceProvider();
        DatastoreServiceDescription serviceDescription = this.findSearchDomainService(provider, preferredSearchDomainOrNull);
        if (serviceDescription != null) {
            ISearchDomainService service = provider.getPluginInstance(serviceDescription.getKey());
            List<SearchDomainSearchResult> result = service.search(sequenceSnippet, optionalParametersOrNull);
            SearchDomain searchDomain = new SearchDomain();
            searchDomain.setDataStoreCode(this.config.getDataStoreCode());
            searchDomain.setName(serviceDescription.getKey());
            searchDomain.setLabel(serviceDescription.getLabel());
            for (SearchDomainSearchResult sequenceSearchResult : result) {
                sequenceSearchResult.setSearchDomain(searchDomain);
            }
            return result;
        }
        this.operationLog.warn((Object)"No available sequence database found.");
        return new ArrayList<SearchDomainSearchResult>();
    }

    private DatastoreServiceDescription findSearchDomainService(PluginTaskProvider<ISearchDomainService> provider, String preferredSequenceDatabaseOrNull) {
        List<DatastoreServiceDescription> pluginDescriptions = provider.getPluginDescriptions();
        Collections.sort(pluginDescriptions, new SimpleComparator<DatastoreServiceDescription, String>(){

            public String evaluate(DatastoreServiceDescription item) {
                return item.getKey();
            }
        });
        DatastoreServiceDescription availableService = null;
        for (DatastoreServiceDescription description : pluginDescriptions) {
            ISearchDomainService service = provider.getPluginInstance(description.getKey());
            if (!service.isAvailable()) continue;
            if (description.getKey().equals(preferredSequenceDatabaseOrNull)) {
                return description;
            }
            if (availableService != null) continue;
            availableService = description;
        }
        return availableService;
    }

    @Override
    public PutDataSetService getPutDataSetService() {
        if (this.putService == null) {
            this.putService = new PutDataSetService(ServiceProvider.getOpenBISService(), this.operationLog);
            this.putService.setStoreDirectory(this.storeRoot);
        }
        return this.putService;
    }

    private IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    public void setConfig(IConfigProvider config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableModel internalCreateReportFromDatasets(String userSessionToken, String serviceKey, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        PluginTaskProvider<IReportingPluginTask> reportingPlugins = this.pluginTaskInfoProvider.getReportingPluginsProvider();
        IReportingPluginTask task = reportingPlugins.getPluginInstance(serviceKey);
        IShareIdManager manager = this.getShareIdManager();
        try {
            String dssCode = this.config.getDataStoreCode();
            for (DatasetDescription dataSet : datasets) {
                if (!dssCode.equals(dataSet.getDataStoreCode())) continue;
                manager.lock(dataSet.getDataSetCode());
            }
            IMailClient mailClient = this.createEMailClient();
            TableModel tableModel = task.createReport(datasets, new DataSetProcessingContext(this.getHierarchicalContentProvider(), new DataSetDirectoryProvider(this.storeRoot, manager), new SessionWorkspaceProvider(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken), new HashMap<String, String>(), mailClient, userId, userEmailOrNull, userSessionToken));
            return tableModel;
        }
        finally {
            manager.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableModel internalCreateReportFromAggregationService(String userSessionToken, String serviceKey, Map<String, Object> parameters, String userId, String userEmailOrNull) {
        PluginTaskProvider<IReportingPluginTask> reportingPlugins = this.pluginTaskInfoProvider.getReportingPluginsProvider();
        IReportingPluginTask task = reportingPlugins.getPluginInstance(serviceKey);
        IShareIdManager manager = this.getShareIdManager();
        try {
            IMailClient mailClient = this.createEMailClient();
            TableModel tableModel = task.createAggregationReport(parameters, new DataSetProcessingContext(this.getHierarchicalContentProvider(), new DataSetDirectoryProvider(this.storeRoot, manager), new SessionWorkspaceProvider(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken), new HashMap<String, String>(), mailClient, userId, userEmailOrNull, userSessionToken));
            return tableModel;
        }
        finally {
            manager.releaseLocks();
        }
    }

    private static class UnarchiveProcessingPluginTask
    implements IProcessingPluginTask {
        private static final long serialVersionUID = 1L;
        private IArchiverPlugin archiverTask;

        public UnarchiveProcessingPluginTask(IArchiverPlugin archiverTask) {
            this.archiverTask = archiverTask;
        }

        @Override
        public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
            ArchiverTaskContext archiverContext = DataStoreService.createContext(context);
            return this.archiverTask.unarchive(datasets, archiverContext);
        }
    }

    private static class ArchiveProcessingPluginTask
    implements IProcessingPluginTask {
        private static final long serialVersionUID = 1L;
        private IArchiverPlugin archiverTask;
        private boolean removeFromDataStore;

        public ArchiveProcessingPluginTask(IArchiverPlugin archiverTask, boolean removeFromDataStore) {
            this.archiverTask = archiverTask;
            this.removeFromDataStore = removeFromDataStore;
        }

        @Override
        public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
            ArchiverTaskContext archiverContext = DataStoreService.createContext(context);
            return this.archiverTask.archive(datasets, archiverContext, this.removeFromDataStore);
        }
    }
}

