/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.VirtualHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.ApplicationContext;
import ch.systemsx.cisd.openbis.dss.generic.server.AutoResolveUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServer;
import ch.systemsx.cisd.openbis.dss.generic.server.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IErrorRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IMessageRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.PlainTextRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.RenderingContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.server.SimpleHTMLRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.Utils;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetAwareHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.util.HttpRequestUtils;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DatasetDownloadServlet
extends AbstractDatasetDownloadServlet {
    private static final String PATH_INFO_DB = "path-info-db";
    private static final String DATA_SOURCES = "data-sources";
    private static final long serialVersionUID = 1L;
    private static final String HTML_MODE_DISPLAY = "html";
    private static final String TEXT_MODE_DISPLAY = "txt";
    private static final String SIMPLE_HTML_MODE_DISPLAY = "simpleHtml";
    static final String AUTO_RESOLVE_KEY = "autoResolve";
    static final String FORCE_AUTO_RESOLVE_KEY = "forceAutoResolve";
    static final String MAIN_DATA_SET_PATH_KEY = "mdsPath";
    static final String MAIN_DATA_SET_PATTERN_KEY = "mdsPattern";
    static final String DISABLE_LINKS = "disableLinks";
    static final String IS_LINK_DATASET = "is_link_data";
    private static String DOWNLOAD_URL;

    static void setDownloadUrl(String downloadUrl) {
        DOWNLOAD_URL = downloadUrl.endsWith("/") ? downloadUrl.substring(0, downloadUrl.length() - 1) : downloadUrl;
    }

    public DatasetDownloadServlet() {
    }

    DatasetDownloadServlet(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IRendererFactory rendererFactory = null;
        boolean isLinkData = false;
        try {
            RequestParams requestParams = DatasetDownloadServlet.parseRequestURL(request, "datastore_server");
            isLinkData = requestParams.isLinkData();
            rendererFactory = this.createRendererFactory(requestParams.getDisplayMode());
            HttpSession session = this.tryGetOrCreateSession(request, requestParams.tryGetSessionId());
            if (session == null) {
                DatasetDownloadServlet.printSessionExpired(response);
            } else {
                this.printResponse(response, rendererFactory, requestParams, session);
            }
        }
        catch (Exception e) {
            String dataSources;
            boolean isPathInfoEnabled;
            if (rendererFactory == null) {
                rendererFactory = new PlainTextRendererFactory();
            }
            boolean bl = isPathInfoEnabled = (dataSources = DataStoreServer.getConfigParameters().getProperties().getProperty(DATA_SOURCES)) != null && dataSources.contains(PATH_INFO_DB);
            if (!isPathInfoEnabled) {
                this.printEmptyPage(rendererFactory, request, response);
            }
            if (isLinkData) {
                this.printMessage("No content information is stored with this linked dataset.", rendererFactory, response);
            }
            this.printError(rendererFactory, request, response, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResponse(HttpServletResponse response, IRendererFactory rendererFactory, RequestParams requestParams, HttpSession session) throws UnsupportedEncodingException, IOException {
        String dataSetCode = requestParams.getDataSetCode();
        RenderingContext context = this.createRenderingContext(requestParams, dataSetCode, session);
        try {
            this.renderPage(rendererFactory, response, dataSetCode, context, requestParams, session);
        }
        finally {
            if (context != null && context.getRootContent() != null) {
                context.getRootContent().close();
            }
        }
    }

    private RenderingContext createRenderingContext(RequestParams requestParams, String dataSetCode, HttpSession session) {
        IHierarchicalContent rootContent = null;
        try {
            String sessionTokenOrNull = requestParams.tryGetSessionId();
            IHierarchicalContentProvider contentProvider = this.applicationContext.getHierarchicalContentProvider(sessionTokenOrNull);
            rootContent = contentProvider.asContent(dataSetCode);
        }
        catch (IllegalArgumentException ex) {
            throw new UserFailureException(ex.getMessage());
        }
        try {
            RenderingContext context = new RenderingContext(rootContent, requestParams.getURLPrefix(), requestParams.getPathInfo(), requestParams.tryGetSessionId());
            return context;
        }
        catch (IllegalArgumentException ex) {
            if (rootContent != null) {
                rootContent.close();
            }
            throw ex;
        }
    }

    private IRendererFactory createRendererFactory(String displayMode) {
        if (displayMode.equals(SIMPLE_HTML_MODE_DISPLAY) || displayMode.equals(HTML_MODE_DISPLAY)) {
            return new SimpleHTMLRendererFactory();
        }
        return new PlainTextRendererFactory();
    }

    private static RequestParams parseRequestURL(HttpServletRequest request, String applicationName) throws UnsupportedEncodingException, URISyntaxException {
        int indexOfSchemeEnd;
        int indexOfDomainEnd;
        String pathInfo;
        String dataSetCode;
        String urlPrefix = "/" + applicationName + "/";
        String requestURI = new URI(request.getRequestURI()).getPath();
        if (!requestURI.startsWith(urlPrefix)) {
            throw new EnvironmentFailureException("Request URI '" + requestURI + "' expected to start with '" + urlPrefix + "'.");
        }
        String fullPathInfo = requestURI.substring(urlPrefix.length());
        int indexOfFirstSeparator = fullPathInfo.indexOf(47);
        if (indexOfFirstSeparator < 0) {
            dataSetCode = fullPathInfo;
            pathInfo = "";
        } else {
            dataSetCode = fullPathInfo.substring(0, indexOfFirstSeparator);
            pathInfo = fullPathInfo.substring(indexOfFirstSeparator + 1);
        }
        String urlPrefixWithDataset = requestURI.substring(0, requestURI.length() - pathInfo.length());
        String sessionIDOrNull = request.getParameter("sessionID");
        String displayMode = DatasetDownloadServlet.getDisplayMode(request);
        Boolean autoResolveOrNull = Boolean.valueOf(request.getParameter(AUTO_RESOLVE_KEY));
        boolean autoResolve = autoResolveOrNull != null && autoResolveOrNull != false;
        Boolean forceAutoResolveOrNull = Boolean.valueOf(request.getParameter(FORCE_AUTO_RESOLVE_KEY));
        boolean forceAutoResolve = forceAutoResolveOrNull != null && forceAutoResolveOrNull != false;
        String mainDataSetPathOrNull = request.getParameter(MAIN_DATA_SET_PATH_KEY);
        String mainDataSetPatternOrNull = request.getParameter(MAIN_DATA_SET_PATTERN_KEY);
        boolean shouldSetMainDataSetParamsToNull = !autoResolve && !forceAutoResolve;
        Boolean disableLinks = Boolean.valueOf(request.getParameter(DISABLE_LINKS));
        if (shouldSetMainDataSetParamsToNull || StringUtils.isBlank((CharSequence)mainDataSetPathOrNull)) {
            mainDataSetPathOrNull = null;
        }
        if (shouldSetMainDataSetParamsToNull || StringUtils.isBlank((CharSequence)mainDataSetPatternOrNull)) {
            mainDataSetPatternOrNull = null;
        }
        String requestScheme = request.getScheme();
        String referrer = request.getHeader("referer");
        String referrerScheme = null;
        String referrerDomain = null;
        boolean forceReferrerDomainOnEmptyDownloadURL = false;
        if (referrer != null && (indexOfDomainEnd = StringUtils.ordinalIndexOf((CharSequence)referrer, (CharSequence)"/", (int)3)) != -1 && (indexOfSchemeEnd = (referrerDomain = referrer.substring(0, indexOfDomainEnd)).indexOf("://")) != -1) {
            referrerScheme = referrerDomain.substring(0, indexOfSchemeEnd);
        }
        if (requestScheme != null && referrerScheme != null && !requestScheme.equals(referrerScheme)) {
            forceReferrerDomainOnEmptyDownloadURL = true;
        }
        String isLink = request.getParameter(IS_LINK_DATASET);
        boolean isLinkData = "true".equals(isLink);
        return new RequestParams(dataSetCode, pathInfo, sessionIDOrNull, urlPrefixWithDataset, displayMode, autoResolve, mainDataSetPathOrNull, mainDataSetPatternOrNull, forceAutoResolve, disableLinks, referrerDomain, forceReferrerDomainOnEmptyDownloadURL, isLinkData);
    }

    private static String getDisplayMode(HttpServletRequest request) {
        String displayMode = request.getParameter("mode");
        if (displayMode == null) {
            displayMode = HTML_MODE_DISPLAY;
        }
        return displayMode;
    }

    private void printEmptyPage(IRendererFactory rendererFactory, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = response.getWriter();
        writer.flush();
        writer.close();
    }

    private void printMessage(String message, IRendererFactory rendererFactory, HttpServletResponse response) throws IOException {
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = response.getWriter();
        IMessageRenderer renderer = rendererFactory.createMessageRenderer();
        renderer.setWriter(writer);
        renderer.printMessage(message);
        writer.flush();
        writer.close();
    }

    private void printError(IRendererFactory rendererFactory, HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException {
        if (exception instanceof HighLevelException) {
            operationLog.error((Object)exception.getMessage());
        } else if (operationLog.isInfoEnabled()) {
            StringBuffer url = request.getRequestURL();
            String queryString = request.getQueryString();
            if (StringUtils.isNotBlank((CharSequence)queryString)) {
                url.append("?").append(queryString);
            }
            operationLog.error((Object)("Request " + url + " caused an exception: "), (Throwable)exception);
        }
        String message = exception.getMessage();
        String errorText = StringUtils.isBlank((CharSequence)message) ? exception.toString() : message;
        IErrorRenderer errorRenderer = rendererFactory.createErrorRenderer();
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = response.getWriter();
        errorRenderer.setWriter(writer);
        errorRenderer.printErrorMessage(errorText);
        writer.flush();
        writer.close();
    }

    private void renderPage(IRendererFactory rendererFactory, HttpServletResponse response, String dataSetCode, RenderingContext renderingContext, RequestParams requestParams, HttpSession session) throws IOException {
        IHierarchicalContentNode node = renderingContext.getContentNode();
        if (!node.exists()) {
            throw new EnvironmentFailureException("Resource '" + node.getRelativePath() + "' does not exist in data set '" + dataSetCode + "'.");
        }
        String sessionIdOrNull = requestParams.tryGetSessionId();
        this.ensureDatasetAccessible(dataSetCode, session, sessionIdOrNull);
        if (node.isDirectory()) {
            if (requestParams.isAutoResolve()) {
                this.autoResolve(rendererFactory, response, dataSetCode, renderingContext, requestParams, session, node, false);
            } else if (requestParams.isForceAutoResolve()) {
                this.autoResolve(rendererFactory, response, dataSetCode, renderingContext, requestParams, session, node, true);
            } else {
                this.createPage(rendererFactory, response, dataSetCode, renderingContext, node, requestParams.isDisableLinks());
            }
        } else {
            this.deliverFile(response, dataSetCode, node, requestParams.getDisplayMode());
        }
    }

    private void autoResolve(IRendererFactory rendererFactory, HttpServletResponse response, String dataSetCode, RenderingContext renderingContext, RequestParams requestParams, HttpSession session, IHierarchicalContentNode dirNode, boolean shouldForce) throws IOException {
        assert (dirNode.exists() && dirNode.isDirectory());
        List<IHierarchicalContentNode> mainDataSets = AutoResolveUtils.findSomeMatchingFiles(renderingContext.getRootContent(), requestParams.tryGetMainDataSetPath(), requestParams.tryGetMainDataSetPattern());
        if (mainDataSets.size() == 1 || mainDataSets.size() > 1 && shouldForce) {
            String newRelativePath = mainDataSets.get(0).getRelativePath();
            RenderingContext newRenderingContext = new RenderingContext(renderingContext, newRelativePath);
            DatasetDownloadServlet.autoResolveRedirect(response, newRenderingContext, requestParams);
        } else if (AutoResolveUtils.continueAutoResolving(requestParams.tryGetMainDataSetPattern(), dirNode)) {
            assert (dirNode.getChildNodes().size() == 1);
            String childName = ((IHierarchicalContentNode)dirNode.getChildNodes().get(0)).getName();
            String oldRelativePath = renderingContext.getRelativePath();
            String pathPrefix = StringUtils.isBlank((CharSequence)oldRelativePath) ? "" : oldRelativePath + "/";
            String newRelativePath = pathPrefix + childName;
            RenderingContext newRenderingContext = new RenderingContext(renderingContext, newRelativePath);
            DatasetDownloadServlet.autoResolveRedirect(response, newRenderingContext, requestParams);
        } else {
            this.createPage(rendererFactory, response, dataSetCode, renderingContext, dirNode, requestParams.isDisableLinks());
        }
    }

    private static void autoResolveRedirect(HttpServletResponse response, RenderingContext newContext, RequestParams requestParams) throws IOException {
        String urlPrefix = newContext.getUrlPrefix();
        String relativePath = newContext.getRelativePath();
        String sessionIdOrNull = newContext.getSessionIdOrNull();
        String newLocationDomain = null;
        newLocationDomain = DOWNLOAD_URL.isEmpty() && requestParams.isForceReferrerDomainOnEmptyDownloadURL() ? requestParams.getReferrerDomain() : DOWNLOAD_URL;
        String newLocation = newLocationDomain + urlPrefix + "/" + relativePath + Utils.createUrlParameterForSessionId("?", sessionIdOrNull) + "&disableLinks=" + requestParams.isDisableLinks();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Auto resolve redirect: '%s', context: %s", newLocation, newContext));
        }
        response.sendRedirect(newLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPage(IRendererFactory rendererFactory, HttpServletResponse response, String dataSetCode, RenderingContext renderingContext, IHierarchicalContentNode dirNode, Boolean disableLinks) throws IOException {
        assert (dirNode.isDirectory());
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("For data set '%s' show directory '%s'", dataSetCode, dirNode.getRelativePath() == null ? "/" : dirNode.getRelativePath()));
        }
        IDirectoryRenderer directoryRenderer = rendererFactory.createDirectoryRenderer(renderingContext);
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = null;
        try {
            HttpRequestUtils.setNoCacheHeaders((HttpServletResponse)response);
            writer = response.getWriter();
            directoryRenderer.setWriter(writer);
            directoryRenderer.printHeader();
            String relativeParentPath = renderingContext.getRelativeParentPath();
            if (relativeParentPath != null) {
                directoryRenderer.printLinkToParentDirectory(relativeParentPath, disableLinks);
            }
            List children = dirNode.getChildNodes();
            HierarchicalContentUtils.sortNodes((List)children);
            for (IHierarchicalContentNode childNode : children) {
                String name = childNode.getName();
                String relativePath = childNode.getRelativePath();
                String normalizedRelativePath = relativePath.replace('\\', '/');
                if (childNode.isDirectory()) {
                    directoryRenderer.printDirectory(name, normalizedRelativePath, childNode.getFileLength(), disableLinks);
                    continue;
                }
                Integer checksumOrNull = childNode.isChecksumCRC32Precalculated() ? Integer.valueOf(childNode.getChecksumCRC32()) : null;
                directoryRenderer.printFile(name, normalizedRelativePath, childNode.getFileLength(), checksumOrNull, this.shouldLinksBeDisabled(childNode, disableLinks));
            }
            directoryRenderer.printFooter();
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private boolean shouldLinksBeDisabled(IHierarchicalContentNode node, boolean disableLinks) {
        if (disableLinks) {
            return true;
        }
        IDatasetLocation dataSet = this.tryExtractDataSet(node);
        if (dataSet != null && dataSet.getDataSetCode().equals(dataSet.getDataSetLocation())) {
            return true;
        }
        return disableLinks;
    }

    private IDatasetLocation tryExtractDataSet(IHierarchicalContentNode node) {
        IHierarchicalContentNode wrappedNode;
        if (node instanceof VirtualHierarchicalContent.VirtualNode && (wrappedNode = ((VirtualHierarchicalContent.VirtualNode)node).lastNode()) instanceof DataSetAwareHierarchicalContentNode) {
            return ((DataSetAwareHierarchicalContentNode)wrappedNode).getDataSet();
        }
        return null;
    }

    private void deliverFile(HttpServletResponse response, String dataSetCode, IHierarchicalContentNode fileNode, String displayMode) throws IOException, FileNotFoundException {
        ResponseContentStream responseStream;
        String infoPostfix;
        assert (!fileNode.isDirectory());
        Size thumbnailSize = DatasetDownloadServlet.tryAsThumbnailDisplayMode(displayMode);
        if (thumbnailSize != null) {
            BufferedImage image = DatasetDownloadServlet.createThumbnail(fileNode, thumbnailSize, null);
            infoPostfix = " as a thumbnail.";
            responseStream = DatasetDownloadServlet.createResponseContentStream(image, fileNode.getName());
        } else {
            infoPostfix = ".";
            responseStream = DatasetDownloadServlet.createResponseContentStream(fileNode, displayMode);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("For data set '" + dataSetCode + "' deliver file '" + fileNode.getRelativePath() + "' (" + responseStream.getSize() + " bytes)" + infoPostfix));
        }
        this.writeResponseContent(responseStream, response);
    }

    private static final ResponseContentStream createResponseContentStream(BufferedImage image, String fileNameOrNull) throws IOException {
        return ResponseContentStream.createPNG(image, fileNameOrNull);
    }

    private static ResponseContentStream createResponseContentStream(IHierarchicalContentNode contentNode, String displayMode) throws FileNotFoundException {
        String contentType = Utils.getMimeType(contentNode, displayMode.equals(TEXT_MODE_DISPLAY));
        return ResponseContentStream.create(contentNode.getInputStream(), contentNode.getFileLength(), contentType, contentNode.getName());
    }

    private static class RequestParams {
        private final String dataSetCode;
        private final String pathInfo;
        private final String sessionIdOrNull;
        private final String urlPrefixWithDataset;
        private final String displayMode;
        private final boolean autoResolve;
        private final String mainDataSetPathOrNull;
        private final String mainDataSetPatternOrNull;
        private final boolean forceAutoResolve;
        private final boolean disableLinks;
        private final String referrerDomain;
        private final boolean forceReferrerDomainOnEmptyDownloadURL;
        private final boolean isLinkData;

        public RequestParams(String dataSetCode, String pathInfo, String sessionIdOrNull, String urlPrefixWithDataset, String displayMode, boolean autoResolve, String mainDataSetPathOrNull, String mainDataSetPatternOrNull, boolean forceAutoResolve, boolean disableLinks, String referrerDomain, boolean forceReferrerDomainOnEmptyDownloadURL, boolean isLinkData) {
            this.dataSetCode = dataSetCode;
            this.pathInfo = pathInfo;
            this.sessionIdOrNull = sessionIdOrNull;
            this.urlPrefixWithDataset = urlPrefixWithDataset;
            this.displayMode = displayMode;
            this.autoResolve = autoResolve;
            this.mainDataSetPathOrNull = mainDataSetPathOrNull;
            this.mainDataSetPatternOrNull = mainDataSetPatternOrNull;
            this.forceAutoResolve = forceAutoResolve;
            this.disableLinks = disableLinks;
            this.referrerDomain = referrerDomain;
            this.forceReferrerDomainOnEmptyDownloadURL = forceReferrerDomainOnEmptyDownloadURL;
            this.isLinkData = isLinkData;
        }

        public boolean isAutoResolve() {
            return this.autoResolve;
        }

        public boolean isForceAutoResolve() {
            return this.forceAutoResolve;
        }

        public String getDataSetCode() {
            return this.dataSetCode;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String tryGetSessionId() {
            return this.sessionIdOrNull;
        }

        public String getDisplayMode() {
            return this.displayMode;
        }

        public String getURLPrefix() {
            return this.urlPrefixWithDataset;
        }

        public String tryGetMainDataSetPath() {
            return this.mainDataSetPathOrNull;
        }

        public String tryGetMainDataSetPattern() {
            return this.mainDataSetPatternOrNull;
        }

        public boolean isDisableLinks() {
            return this.disableLinks;
        }

        public String getReferrerDomain() {
            return this.referrerDomain;
        }

        public boolean isForceReferrerDomainOnEmptyDownloadURL() {
            return this.forceReferrerDomainOnEmptyDownloadURL;
        }

        public boolean isLinkData() {
            return this.isLinkData;
        }
    }
}

